/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang;

public abstract class Number {
	
	static native boolean isInfiniteImpl(double x)/*{
		return !isFinite(x);
	}*/;
	
	static native boolean isNaNImpl(double x)/*{
		return isNaN(x);
	}*/;

	static native long toLongImpl(String str, int radix)/*{
		//TODO - add string validation
		return parseInt(str, radix);
	}*/;
	
	static native long toDoubleImpl(String str)/*{
		//TODO - add string validation
		return parseFloat(str);
	}*/;

	static long toLongDecode(String str, long min, long max) {
		if (str == null || str.length() == 0) throw new NumberFormatException();
		boolean sign = str.charAt(0) == '-';
		int radix;
		if (sign) str = str.substring(1);
		if (str.startsWith("0x") || str.startsWith("0X")) {
			radix = 16;
			str = str.substring(2);
		}
		else if (str.startsWith("#")) {
			radix = 16;
			str = str.substring(1);
		}
		else if (str.startsWith("0")) {
			radix = 8;
			str = str.substring(1);
		} else {
			radix = 10;
		}
		if (sign) str = "-" + str;
		return toLong(str, radix, min, max);
	}
	
	static long toLong(String str, int radix, long min, long max) {
		if (str == null) throw new NumberFormatException();
		long result = toLongImpl(str, radix);		
		if (!isNaNImpl(result) && min <= result && result <= max) return result;
		throw new NumberFormatException();
	}
	
	static long toDouble(String str, double min, double max) {
		if (str == null) throw new NumberFormatException();
		long result = toDoubleImpl(str);		
		if (!isNaNImpl(result) && min <= result && result <= max) return result;
		throw new NumberFormatException();
	}

	public abstract byte byteValue();

	public abstract double doubleValue();

	public abstract float floatValue();

	public abstract int intValue();

	public abstract long longValue();

	public abstract short shortValue();
}
