/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang;

public final class Short extends Number implements Comparable {
	
	private final short value;
	
	public static final short MIN_VALUE = -32768;

	public static final short MAX_VALUE = 32767;

	public static final Class TYPE = new Class("short");

	public static Short decode(String s) throws NumberFormatException {
		return new Short((short)toLongDecode(s, MIN_VALUE, MAX_VALUE));
	}

	public static short parseShort(String s) throws NumberFormatException {
		return parseShort(s, 10);
	}

	public static short parseShort(String s, int radix) throws NumberFormatException {
		return (short)toLong(s, radix, MIN_VALUE, MAX_VALUE);
	}

	public static String toString(short b) {
		return String.valueOf(b);
	}

	public static Short valueOf(String s) throws NumberFormatException {
		return new Short(Short.parseShort(s));
	}

	public static Short valueOf(String s, int radix) throws NumberFormatException {
		return new Short(Short.parseShort(s, radix));
	}

	public Short(short value) {
		this.value = value;
	}

	public Short(String s) {
		value = parseShort(s);
	}

	public byte byteValue() {
		return (byte) value;
	}

	public int compareTo(Object o) {
		return compareTo((Short) o);
	}

	public int compareTo(Short b) {
		if (value < b.value) return -1;
		if (value > b.value) return 1;
		return 0;
	}

	public double doubleValue() {
		return value;
	}

	public boolean equals(Object obj) {
		return (obj instanceof Short) && (((Short) obj).value == value);
	}

	public float floatValue() {
		return value;
	}

	public int hashCode() {
		return value;
	}

	public int intValue() {
		return value;
	}

	public long longValue() {
		return value;
	}

	public short shortValue() {
		return value;
	}

	public String toString() {
		return toString(value);
	}
}
