/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang;

public final class StringBuffer implements CharSequence {
	
	private String buffer;

	public StringBuffer() {
		buffer = "";
	}

	public StringBuffer(int length) {
		buffer = "";
	}

	public StringBuffer(String s) {
		buffer = s;
	}

	public StringBuffer append(boolean x) {
		return append(String.valueOf(x));
	}

	public StringBuffer append(char x) {
		return append(String.valueOf(x));
	}

	public StringBuffer append(char[] chs) {
		return append(chs, 0, chs.length);
	}

	public StringBuffer append(char[] chs, int offset, int len) {
		return append(String.valueOf(chs, offset, len));
	}

	public StringBuffer append(double x) {
		return append(String.valueOf(x));
	}

	public StringBuffer append(float x) {
		return append(String.valueOf(x));
	}

	public StringBuffer append(int x) {
		return append(String.valueOf(x));
	}

	public StringBuffer append(long x) {
		return append(String.valueOf(x));
	}

	public StringBuffer append(Object x) {
		return append(String.valueOf(x));
	}

	public native StringBuffer append(String str)/*{
		buffer += str;
		return this;
	}*/;

	public StringBuffer append(StringBuffer x) {
		return append(x == null ? "null" : x.toString());
	}

	public char charAt(int index) {
		return toString().charAt(index);
	}

	public StringBuffer delete(int start, int end) {
		return replace(start, end, "");
	}

	public StringBuffer deleteCharAt(int start) {
		return delete(start, start + 1);
	}

	public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
		String str = toString();
		while (srcBegin < srcEnd) {
			dst[dstBegin++] = str.charAt(srcBegin++);
		}
	}

	public int indexOf(String x) {
		return toString().indexOf(x);
	}

	public int indexOf(String x, int start) {
		return toString().indexOf(x, start);
	}

	public StringBuffer insert(int index, boolean x) {
		return insert(index, String.valueOf(x));
	}

	public StringBuffer insert(int index, char x) {
		return insert(index, String.valueOf(x));
	}

	public StringBuffer insert(int index, char[] x) {
		return insert(index, String.valueOf(x));
	}

	public StringBuffer insert(int index, char[] x, int offset, int len) {
		return insert(index, String.valueOf(x, offset, len));
	}

	public StringBuffer insert(int index, double x) {
		return insert(index, String.valueOf(x));
	}

	public StringBuffer insert(int index, float x) {
		return insert(index, String.valueOf(x));
	}

	public StringBuffer insert(int index, int x) {
		return insert(index, String.valueOf(x));
	}

	public StringBuffer insert(int index, long x) {
		return insert(index, String.valueOf(x));
	}

	public StringBuffer insert(int index, Object x) {
		return insert(index, String.valueOf(x));
	}

	public StringBuffer insert(int index, String x) {
		return replace(index, index, x);
	}

	public int lastIndexOf(String s) {
		return toString().lastIndexOf(s);
	}

	public int lastIndexOf(String s, int start) {
		return toString().lastIndexOf(s, start);
	}

	public int length() {
		return buffer.length();
	}

	public StringBuffer replace(int start, int end, String str) {
		int length = length();
		if (0 <= start && start < length && 0 <= end && end <= length) {
			replaceImpl(start, end, str);
			return this;
		}
		throw new StringIndexOutOfBoundsException();
	}
	
	private native void replaceImpl(int start, int end, String str)/*{
		var s1:String = buffer.slice(0, start);
		var s2:String = buffer.slice(end);
		buffer = s1 + s2;
	}*/;

	public void setCharAt(int index, char x) {
		replace(index, index + 1, String.valueOf(x));
	}

	public void setLength(int newLength) {
		int oldLength = length();
		if (newLength < oldLength) {
			delete(newLength, oldLength);
		} else {
			while (oldLength < newLength) {
				append((char) 0);
				++oldLength;
			}
		}
	}

	public CharSequence subSequence(int start, int end) {
		return toString().substring(start, end);
	}

	public String substring(int begin) {
		return toString().substring(begin);
	}

	public String substring(int begin, int end) {
		return toString().substring(begin, end);
	}

	public String toString() {
		return buffer;
	}

}
