/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang.ref;

public abstract class Reference extends Object {
	private Object ref;

Reference() {
}
	
public void clear() {
	ref = null;
}

public Object get() {
	if (ref == null) return null;
	return getImpl();
}

private native Object getImpl()/*{
	for(var item:* in ref) {
		return item;
	}
	ref = null;
	return null;
}*/;

void set(Object obj) {
	ref = new intrinsic.flash.utils.Dictionary(true);
	setImpl(obj);
}

private native void setImpl(Object obj)/*{	
	ref[obj] = 1;
*/;

}
