/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang.reflect;

public class Field extends AccessibleObject implements Member {
	Class declaringClass;	
	String name;
	int modifiers;
	
Field (String fieldName, Class declaringClass) {
	this.name = fieldName;
	this.declaringClass = declaringClass;
}

public boolean equals(Object other) {
	if (this == other) return true;
	if (!(other instanceof Method)) return false;
	//TODO return type and parameters
	Method mth = (Method)other;
	return declaringClass == mth.declaringClass &&
		modifiers == mth.modifiers &&
		name.equals(mth.name);
}

public native Object get(Object obj) throws  IllegalArgumentException, IllegalAccessException /*{
	if (obj.getClass__() != declaringClass) {
		//TODO throw exception
		return null;
	}
	return obj[name];
}*/;

public Class getDeclaringClass() {
	return declaringClass;
}

public int getModifiers() {
	return modifiers;
}

public String getName() {
	return name;
}
}
