/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang.reflect;

public class Method extends AccessibleObject implements Member {

	Class declaringClass;
	int modifiers;
	String name;
	
public boolean equals(Object other) {
	if (this == other) return true;
	if (!(other instanceof Method)) return false;
	//TODO return type and parameters
	Method mth = (Method)other;
	return declaringClass == mth.declaringClass &&
		modifiers == mth.modifiers &&
		name.equals(mth.name);
}

public Class getDeclaringClass() {
	return declaringClass;
}

public Class[] getExceptionTypes() {
	//TODO
	return new Class[0];
}

public int getModifiers() {
	return modifiers;
}

public String getName() {
	return name;
}

public Class[] getParameterTypes() {
	//TODO
	return new Class[0];
}

public Class getReturnType() {
	//TODO
	return null;
}

public int hashCode() {
	//TODO
	return super.hashCode();
}

public Object invoke(Object obj, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
	//TODO
	return null;
}

public String toString() {
	// TODO Auto-generated method stub
	return super.toString();
}
}
