/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang.reflect;

public class Modifier {

	public static final int ABSTRACT = 1024;
	public static final int FINAL = 16;
	public static final int INTERFACE = 512;
	public static final int NATIVE = 256;
	public static final int PRIVATE = 2;
	public static final int PROTECTED = 4;
	public static final int PUBLIC = 1;
	public static final int STATIC = 8;
	public static final int STRICT = 2048;
	public static final int SYNCHRONIZED = 32;
	public static final int TRANSIENT = 128;
	public static final int VOLATILE = 64;

public static boolean isAbstract(int mod) {
	return (mod & ABSTRACT) != 0;
}

public static boolean isFinal(int mod) {
	return (mod & FINAL) != 0;
}

public static boolean isInterface(int mod) {
	return (mod & INTERFACE) != 0;
}

public static boolean isNative(int mod) {
	return (mod & NATIVE) != 0;
}

public static boolean isPrivate(int mod) {
	return (mod & PRIVATE) != 0;
}

public static boolean isProtected(int mod) {
	return (mod & PROTECTED) != 0;
}

public static boolean isPublic(int mod) {
	return (mod & PUBLIC) != 0;
}

public static boolean isStatic(int mod) {
	return (mod & STATIC) != 0;
}

public static boolean isStrict(int mod) {
	return (mod & STRICT) != 0;
}

public static boolean isSynchronized(int mod) {
	return (mod & SYNCHRONIZED) != 0;
}

public static boolean isTransient(int mod) {
	return (mod & TRANSIENT) != 0;
}

public static boolean isVolatile(int mod) {
	return (mod & VOLATILE) != 0;
}

public String toString() {
	// TODO Auto-generated method stub
	return super.toString();
}
}
