/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.util;

import java.lang.reflect.Array;

public abstract class AbstractCollection implements Collection {
	
protected AbstractCollection() {
}

public boolean add(Object o) {
	throw new UnsupportedOperationException();
}

public boolean addAll(Collection c) {
	boolean result = false;
	Iterator iterator = c.iterator();
	while (iterator.hasNext()) {
		result |= add(iterator.next());
	}	
	return result;
}

public void clear() {
	Iterator iterator = iterator();
	while (iterator.hasNext()) {
		iterator.remove();
	}
}

public boolean contains(Object o) {
	Iterator iterator = iterator();
	while (iterator.hasNext()) {
		Object element = iterator.next();
		if (o == null ? element == null : o.equals(element)) {
			return true;
		}
	}
	return false;
}

public boolean containsAll(Collection c) {
	int count = c.size();
	Iterator iterator = c.iterator();
	while (iterator.hasNext()) {
		if (contains(iterator.next())) count--;
	}	
	return count == 0;
}

public boolean isEmpty() {
	return size() == 0;
}

public abstract Iterator iterator();

public boolean remove(Object o) {
	Iterator iterator = iterator();
	while (iterator.hasNext()) {
		Object element = iterator.next();
		if (o == null ? element == null : o.equals(element)) {
			iterator.remove();
			return true;
		}
	}
	return false;
}

public boolean removeAll(Collection c) {
	boolean result = false;
	Iterator iterator = c.iterator();
	while (iterator.hasNext()) {
		result |= remove(iterator.next());
	}	
	return result;
}

public boolean retainAll(Collection c) {
	boolean result = false;
	Iterator iterator = iterator();
	while (iterator.hasNext()) {
		Object element = iterator.next();
		if (!c.contains(element)) {
			iterator.remove();
			result |= true;
		}
	}
	return result;
}

public abstract int size();

public Object[] toArray() {
	Object[] result = new Object[size()];
	int i = 0;
	Iterator iterator = iterator();
	while (iterator.hasNext()) {
		result[i] = iterator.next();
	}
	return result;
}

public Object[] toArray(Object[] a) {
	Object[] result = a;
	int size = size();
	if (a.length < size) result = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
	int i = 0;
	Iterator iterator = iterator();
	while (iterator.hasNext()) {
		result[i] = iterator.next();
	}
	if (a.length < size) result[i] = null;
	return result;
}

public String toString() {
	StringBuffer buffer = new StringBuffer();
	buffer.append("[");
	boolean first = false;
	Iterator iterator = iterator();
	while (iterator.hasNext()) {
		if (!first) buffer.append(", ");
		first = false;
		buffer.append(iterator.next());
	}
	buffer.append("]");
	return buffer.toString();
}

}
