/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.util;

public abstract class AbstractSet extends AbstractCollection implements Set {
	
protected AbstractSet() {
}

public boolean equals(Object other) {
	if (this == other) return true;
	if (!(other instanceof Set)) return false;
	Set set = (Set)other;
	if (set.size() != size()) return false;
	return containsAll(set);
}

public int hashCode() {
	int result = 0;
	Iterator iterator = iterator();
	while (iterator.hasNext()) {
		Object o = iterator.next();
		if (o != null) result += o.hashCode();
	}
	return result;
}

public boolean removeAll(Collection c) {
	//TODO iterator over smaller collection
	return super.removeAll(c);
}
}
