/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.util;

public class Date {
	
	private long time;

public Date() {
	this.time = System.currentTimeMillis();
}

public Date(long date) {
	this.time = date;
}

public boolean equals(Object other) {
	if (other == this) return true;
	if (!(other instanceof Date)) return false;
	return time == ((Date)other).time;
}

public long getTime() {
	return time;
}

public int hashCode() {
	return (int)(time >> 32) ^ (int)time;
}

public void setTime(long time) {
	this.time = time;
}

public native String toString()/*{
	return new Date(time).toString();
}*/;
}