/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.util;

import intrinsic.Date;

class GregorianCalendar extends Calendar {

	static final int FIELD_COUNT = MILLISECOND + 1;
	
public GregorianCalendar() {
	//TODO - this is done to avoid a compiler bug
	int[] f = new int[FIELD_COUNT];
	fields = f;
	isSet = new boolean[FIELD_COUNT];
}
	
protected void computeFields() {
	Date date = new Date(time);
	fields[YEAR] = (int)date.fullYear;
	fields[MONTH] = (int)date.month;
	fields[DATE] = (int)date.date;
	fields[HOUR] = (int)date.hours % 12;
	fields[MINUTE] = (int)date.minutes;
	fields[SECOND] = (int)date.seconds;
	fields[MILLISECOND] = (int)date.milliseconds;	
	fields[DAY_OF_WEEK] = (int)(date.day - 1);
	fields[HOUR_OF_DAY] = (int)date.hours;
	fields[AM_PM] = date.hours > 12 ? PM : AM;	
	for (int i = 0; i < isSet.length; i++) {
		isSet[i] = true;
	}
}

protected void computeTime() {
	int year = isSet[YEAR] ? fields[YEAR] : 0;
	int month = isSet[MONTH] ? fields[MONTH] : 0;
	int day = isSet[DATE] ? fields[DATE] : 0;
	int hour = 0;
	if (isSet[HOUR_OF_DAY]) {
		hour = fields[HOUR_OF_DAY];
	} else if (isSet[HOUR] && isSet[AM_PM]){
		hour = fields[HOUR];
		if (fields[AM_PM] == PM) hour += 12;
	}
	int minute = isSet[MINUTE] ? fields[MINUTE] : 0;
	int second = isSet[SECOND] ? fields[SECOND] : 0;
	int millisecond = isSet[MILLISECOND] ? fields[MILLISECOND] : 0;
	Date date = new Date(year, month, day, hour, minute, second, millisecond);
	time = date.getTime();
}
}
