/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.util;

public class HashSet extends AbstractSet {
	HashMap map;	
	
public HashSet() {
	this(16, 0.75f);
}

public HashSet(Collection c) {
	this(c.size(), 0.75f);
	addAll(c);
}

public HashSet(int initialCapacity) {
	this(initialCapacity, 0.75f);
}

public HashSet(int initialCapacity, float loadFactor) {
	map = new HashMap(initialCapacity, loadFactor);
}

public boolean add(Object o) {
	if (map.get(o) == null) {
		map.put(o, o);
		return true;
	}
	return false;
}

public void clear() {
	map.clear();
}

public boolean contains(Object o) {
	return map.containsKey(o);
}

public boolean isEmpty() {
	return map.isEmpty();
}

public Iterator iterator() {
	return map.keySet().iterator();
}

public boolean remove(Object o) {
	boolean result = map.get(o) != null;
	map.remove(o);
	return result;
}

public int size() {
	return map.size();
}
}
