/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.util;

public class Locale implements Cloneable {
	String language, country, variant;

	static Locale DefaultLocale;
	
	public static final Locale CANADA = new Locale("en", "CA");
	public static final Locale CANADA_FRENCH = new Locale("fr", "CA");
	public static final Locale CHINA = new Locale("zh", "CN");
	public static final Locale CHINESE = new Locale("zh");
	public static final Locale ENGLISH = new Locale("en");
	public static final Locale FRANCE = new Locale("fr", "FR");
	public static final Locale FRENCH = new Locale("fr");
	public static final Locale GERMAN = new Locale("de");
	public static final Locale GERMANY = new Locale("de", "DE");
	public static final Locale ITALIAN = new Locale("it");
	public static final Locale ITALY = new Locale("it", "IT");
	public static final Locale JAPAN = new Locale("ja", "JP");
	public static final Locale JAPANESE = new Locale("ja");
	public static final Locale KOREA = new Locale("ko", "KR");
	public static final Locale KOREAN = new Locale("ko");
	public static final Locale PRC = new Locale("zh", "CN");
	public static final Locale SIMPLIFIED_CHINESE = new Locale("zn", "CN");
	public static final Locale TAIWAN = new Locale("zh", "TW");
	public static final Locale TRADITIONAL_CHINESE = new Locale("zh", "TW");
	public static final Locale UK = new Locale("en", "GB");
	public static final Locale US = new Locale("en", "US");

	static {
		DefaultLocale = new Locale(
			System.getProperty("user.language", "en"),
			System.getProperty("user.country", ""),
			System.getProperty("user.variant", ""));
	}

public Locale(String language) {
	this(language, "", "");
}

public Locale(String language, String country) {
	this(language, country, "");
}

public Locale(String language, String country, String variant) {
	if (language == null || country == null || variant == null) {
		throw new NullPointerException();
	}
	this.language = language;
	this.country = country;
	this.variant = variant;
}

public Object clone() {
	return new Locale(language, country, variant);
}

public boolean equals(Object other) {
	if (this == other) return true;
	if (!(other instanceof Locale)) return false;
	Locale locale = (Locale)other;
	return language.equals(locale.language) &&
		country.equals(locale.country) &&
		variant.equals(locale.variant);
}

public Locale[] getAvailableLocales() {
	//TODO
	return new Locale[0];
}

public String getCountry() {
	return country;
}

public static Locale getDefault() {
	return DefaultLocale;
}

public String getDisplayCountry() {
	return getDisplayCountry(getDefault());
}

public String getDisplayCountry(Locale locale) {
	//TODO
	return country;
}

public String getDisplayLanguage() {
	return getDisplayLanguage(getDefault());
}

public String getDisplayLanguage(Locale locale) {
	//TODO
	return language;
}

public String getDisplayName() {
	return getDisplayName(getDefault());
}

public String getDisplayName(Locale locale) {
	//TODO
	return null;
}

public String getDisplayVariant() {
	return getDisplayVariant(getDefault());
}

public String getDisplayVariant(Locale locale) {
	//TODO
	return variant;
}

public String getLanguage() {
	return language;
}

public String getISO3Country() {
	//TODO
	return null;
}

public String getISO3Language() {
	//TODO
	return null;
}

public static String[] getISO3Countries() {
	//TODO
	return null;
}

public static String[] getISO3Languages() {
	//TODO
	return null;
}

public String getVariant() {
	return variant;
}

public int hashCode() {
	return language.hashCode() ^ country.hashCode() ^ variant.hashCode();
}

public static void setDefault(Locale locale) {
	if (locale == null) throw new NullPointerException();
	DefaultLocale = locale;
}

public String toString() {
	if (language.length() == 0 && country.length() == 0) return "";
	if (country.length() == 0 && variant.length() == 0) return language;
	StringBuffer buffer = new StringBuffer();
	buffer.append(language);
	buffer.append("_");
	buffer.append(country);
	if (variant.length() > 0) {
		buffer.append("_");
		buffer.append(variant);
	}
	return buffer.toString();
}
}
