/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.util;

public class Random {
	
	private long seed;

public Random() {
	this(System.currentTimeMillis());
}

public Random(long seed) {
	setSeed(seed);
}

protected synchronized int next(int bits) {
	seed = (seed * 0x5DEECE66DL + 0xBL) & ((1L << 48) - 1);
	return (int)(seed >>> (48 - bits));
}

public boolean nextBoolean() {
	return next(1) != 0;
}

public double nextDouble() {
	return (((long)next(26) << 27) + next(27)) / (double)(1L << 53);
}

public float nextFloat() {
	return next(24) / ((float)(1 << 24));
}

public int nextInt() {
	return next(32);
}

public int nextInt(int n) {
	return (int) (intrinsic.Math.random() * n);
};

//public int nextInt(int n) {
//	if (n <= 0) throw new IllegalArgumentException();
//	if ((n & -n) == n) {
//		return (int)((n * (long)next(31)) >> 31);
//	}
//	int bits, val;
//	do {
//		bits = next(31);
//		val = bits % n;
//	} while (bits - val + (n - 1) < 0);
//	return val;
//}

public long nextLong() {
	return ((long)next(32) << 32) + next(32);
}

public void setSeed(long seed) {
	this.seed = (seed ^ 0x5DEECE66DL) & ((1L << 48) - 1);
}
}