/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.util;

class SimpleTimeZone extends TimeZone {

	int offset;
	
public SimpleTimeZone(String id, int offset) {
	this.id = id;
	this.offset = offset;
}

public int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis) {
	//TODO - take into account daylight time
	return getRawOffset();
}

public int getRawOffset() {
	return offset;
}

public boolean useDaylightTime() {
	//TODO - determine daylight time
	return false;
}

public String toString() {
	return getClass().getName() + "{" + id + "," + offset + "}";
}

}
