/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.util;

public class Stack extends Vector {
	
public Stack() {
	super();
}

public boolean empty() {
	return isEmpty();
}

public Object peek() {
	try {
		return lastElement();
	} catch (IndexOutOfBoundsException e) {
		throw new EmptyStackException();
	}
}

public Object pop() {
	try {
		int index = size() - 1;
		Object result = elementAt(index);
		removeElementAt(index);
		return result;
	} catch (IndexOutOfBoundsException e) {
		throw new EmptyStackException();
	}
}

public void push(Object item) {
	addElement(item);
}

public int search(Object o) {
	int index = lastIndexOf(o);
	if (index == -1) return -1;
	return size() - index;
}
}