/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.util;

public abstract class TimeZone {

	String id;
	
	static TimeZone[] TimeZones;
	
public TimeZone() {
}

public static String[] getAvailableIDs() {
	initTimeZones();
	String[] ids = new String[TimeZones.length];
	for (int i = 0; i < ids.length; i++) {
		ids[i] = TimeZones[i].getID();
	}
	return ids;
}

public static TimeZone getDefault() {
	initTimeZones();
	return TimeZones[TimeZones.length - 1];
}

public String getID() {
	return id;
}

private static native TimeZone getLocalTimeZone ()/*{
	var date:Date = new Date();
	var str:String = date.toString();
	var end:int = str.lastIndexOf(" ");
	var start:int = str.lastIndexOf(" ", end - 1);
	return new SimpleTimeZone(str.substring(start + 1, end), date.timezoneOffset * -60000);
}*/;

public abstract int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis);

public abstract int getRawOffset();

public static TimeZone getTimeZone(String ID) {
	initTimeZones();
	for (int i = 0; i < TimeZones.length; i++) {
		if (TimeZones[i].getID().equals(ID)) return TimeZones[i];
	}
	return null;
}

private static void initTimeZones() {
	if (TimeZones != null) return;
	TimeZone gmt = new SimpleTimeZone("GMT", 0);
	TimeZone local = getLocalTimeZone();
	if (local == null)  {
		TimeZones = new TimeZone[]{gmt};
	} else {
		TimeZones = new TimeZone[]{gmt, local};
	}
}

public abstract boolean useDaylightTime();
}