/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.util;

import intrinsic.Function;
import intrinsic.flash.events.TimerEvent;

public abstract class TimerTask implements Runnable {

	boolean canceled;
	long period, scheduleTime;
	Timer timer;
	intrinsic.flash.utils.Timer timeout;
	
protected TimerTask() {
}

public boolean cancel() {
	if (canceled) return false;
	if (timeout != null) timeout.stop();
	//TODO
	return true;
}

void handleTimer (intrinsic.flash.events.TimerEvent event) {
	scheduleTime = System.currentTimeMillis();
	if (canceled || timer.cancelled) return;
	run();
	timeout.stop();
	if (period != 0) {
		timeout = new intrinsic.flash.utils.Timer(period, 1);
		timeout.start();
		timeout.addEventListener(TimerEvent.TIMER, handleTimerFunction());
	}
}

native Function handleTimerFunction ()/*{
	return handleTimer__Lflash_events_TimerEvent_2;
}*/;


public abstract void run();

void start(Timer timer, long delay, long period) {
	this.timer = timer;
	this.period = period;
	timeout = new intrinsic.flash.utils.Timer(delay, 1);
	timeout.start();
	timeout.addEventListener(TimerEvent.TIMER, handleTimerFunction());
}

public long scheduledExecutionTime() {
	return scheduleTime;
}
}
