/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.google.gwt.lang;

public class Array {
	 /**
	   * Creates a new array of the exact same type and length as a given array.
	   */
	  public static  <T> T[] createFrom(T[] array) {
		  return createFrom(array, array.length);
	  }

	  /**
	   * Creates an empty array of the exact same type as a given array, with the
	   * specified length.
	   */
	  public static  <T> T[] createFrom(T[] array, int length) {
		  return (T[]) java.lang.reflect.Array.newInstance(array.getClass().getComponentType(), length);
	  }
	  
	  /**
	   * Creates a copy of a subrange of the specified array.
	   */
	  public static <T> T[] cloneSubrange(T[] array, int fromIndex, int toIndex) {
		  T[] object = createFrom(array, toIndex - fromIndex);
		  System.arraycopy(array, fromIndex, object, toIndex, toIndex - fromIndex);
		  return object;
	  }
	  
	  /**
	   * Creates a copy of the specified array.
	   */
	  public static <T> T[] clone(T[] array) {
		 return cloneSubrange(array, 0, array.length);
	  }

}
