/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.io;

public class OutputStreamWriter extends Writer {
	
	private OutputStream out;
	private String encoding;
	
public OutputStreamWriter(OutputStream out) {
	if (out == null) throw new NullPointerException();
	this.out = out;
	this.encoding = System.getProperty("file.encoding");
}

public OutputStreamWriter(OutputStream out, String encoding) {
	if (out == null) throw new NullPointerException();
	this.out = out;
	this.encoding = encoding;
}

public void close() throws IOException {
	out.close();
}

private native int convert(String s, String encoding, byte[] buffer)/*{
	buffer.array.writeMultiByte(s, encoding);
	return buffer.array.position;
}*/;

public void flush() throws IOException {
	out.flush();
}

public void write(int c) throws IOException {
	write(String.valueOf((char)c));
}

public void write(char[] cbuf, int off, int len) throws IOException {
	write(String.valueOf(cbuf, off, len));
}

public void write(String str, int off, int len) throws IOException {
	byte[] buffer = new byte[str.length() * 2];
	int count = convert(str, encoding, buffer);
	out.write(buffer, 0, count);
}
}