/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang;

import intrinsic.flash.system.ApplicationDomain;

import java.io.InputStream;

public abstract class ClassLoader {
	
static native byte[] createArray(Object cls)/*{
	import flash.utils.*;
	var array : ByteArray = new cls(); 
	var result:JavaArray = new JavaArray("[B");
	result.array = array;
	return result;
}*/;

public static InputStream getSystemResourceAsStream(String name) {
	if (name == null) throw new NullPointerException();
	name = "Resources_" + mangleResourceName(name);
	if (!ApplicationDomain.currentDomain.hasDefinition(name)) return null;
	Object clazz = ApplicationDomain.currentDomain.getDefinition(name);
	if (clazz == null) return null;
	byte[] resource = createArray(clazz);
	return new java.io.ByteArrayInputStream(resource);
}

static String mangleResourceName (String tempString) {
	String mangledName = tempString.replace(' ','_');
	mangledName = mangledName.replace('/', '_');
	mangledName = mangledName.replace('.', '_');
	mangledName = mangledName.replace('-', '_');
	return mangledName;
}

}
