/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang;

import java.io.*;

public final class String implements Comparable, CharSequence {

	  static void __checkBounds(int legalCount, int start, int end) {
		    if (start < 0) {
		      throw new StringIndexOutOfBoundsException(start);
		    }
		    if (end < start) {
		      throw new StringIndexOutOfBoundsException(end - start);
		    }
		    if (end > legalCount) {
		      throw new StringIndexOutOfBoundsException(end);
		    }
		  }
	  
	public static native String valueOf(boolean x);

	public static native String valueOf(char x);

	public static native String valueOf(char x[], int offset, int count);

	public static native String valueOf(char[] x);

	public static native String valueOf(double x);

	public static native String valueOf(float x);

	public static native String valueOf(int x);

	public static native String valueOf(long x);

	public static native String valueOf(Object x);

	public static native String copyValueOf(char x[], int offset, int count);

	public static native String copyValueOf(char[] x);

	public String() {
	}

	public String(char value[]) {
	}

	public String(char value[], int offset, int count) {
	}
	
	public String(byte[] bytes) {
	}
	
	public String(byte[] bytes, int off, int len) {
	}
	
	public String(byte[] bytes, int off, int len, String enc) throws UnsupportedEncodingException {
	}
	
	public String(byte[] bytes, String enc) throws UnsupportedEncodingException {
	}
	
	public String(StringBuffer buffer) {
	}

	public String(String other) {
	}

	public native char charAt(int index);

	public native int compareTo(Object other);

	public native int compareTo(String other);
	
	public native int compareToIgnoreCase(String other);

	public native String concat(String str);
	
	public native boolean contentEquals(StringBuffer sb);

	public native boolean endsWith(String suffix);

	public native boolean equals(Object other);

	public native boolean equalsIgnoreCase(String other);
	
	public native byte[] getBytes();
	
	public native byte[] getBytes(String enc) throws UnsupportedEncodingException;
	
	public native void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin);

	public native int hashCode();

	public native int indexOf(int ch);

	public native int indexOf(int ch, int startIndex);

	public native int indexOf(String str);

	public native int indexOf(String str, int startIndex);

	public native int lastIndexOf(int ch);

	public native int lastIndexOf(int ch, int startIndex);

	public native int lastIndexOf(String str);

	public native int lastIndexOf(String str, int start);

	public native int length();

	public native boolean matches(String regex);

	public native String replace(char from, char to);

	public native String replaceAll(String regex, String replace);

	public native String replaceFirst(String regex, String replace);

	public native String[] split(String regex);

	public native String[] split(String regex, int maxMatch);

	public native boolean startsWith(String prefix);

	public native boolean startsWith(String prefix, int toffset);

	public native CharSequence subSequence(int beginIndex, int endIndex);

	public native String substring(int beginIndex);

	public native String substring(int beginIndex, int endIndex);

	public native char[] toCharArray();

	public native String toLowerCase();

	public String toString() {
		return this;
	}

	public native String toUpperCase();

	public native String trim();
}
