/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang.reflect;

public final class Array {

public native static Object get(Object array, int index)/*{
	import java.lang.*;
	if (!(array is JavaArray)) throw new IllegalArgumentException("Argument is not an array");
	var value:* = JavaArray(array)[index];
	var clazz:Class__ = array.getClass__().getComponentType__();
	if (clazz == Byte.TYPE) return new Byte(value);
	if (clazz == Boolean__.TYPE) return new Boolean__(value);
	if (clazz == Character.TYPE) return new Character(value);
	if (clazz == Short.TYPE) return new Short(value);
	if (clazz == Integer.TYPE) return new Integer(value);
	if (clazz == Long.TYPE) return new Long(value);
	if (clazz == Double.TYPE) return new Double(value);
	if (clazz == Float.TYPE) return new Float(value);
	return value;
}*/;

public native static boolean getBoolean(Object array, int index)/*{
	import java.lang.*;
	if (!(array is JavaArray)) throw new IllegalArgumentException("Argument is not an array");
	var value:* = JavaArray(array)[index];
	var clazz:Class__ = array.getClass__().getComponentType__();
	if (clazz != Boolean__.TYPE) throw new IllegalArgumentException("Invalid component type");
	return value;
}*/;

public native static byte getByte(Object array, int index)/*{
	import java.lang.*;
	if (!(array is JavaArray)) throw new IllegalArgumentException("Argument is not an array");
	var value:* = JavaArray(array)[index];
	var clazz:Class__ = array.getClass__().getComponentType__();
	if (clazz != Byte.TYPE) throw new IllegalArgumentException("Invalid component type");
	return value;
}*/;

public native static char getChar(Object array, int index)/*{
	import java.lang.*;
	if (!(array is JavaArray)) throw new IllegalArgumentException("Argument is not an array");
	var value:* = JavaArray(array)[index];
	var clazz:Class__ = array.getClass__().getComponentType__();
	if (clazz != Character.TYPE) throw new IllegalArgumentException("Invalid component type");
	return value;
}*/;

public native static double getDouble(Object array, int index)/*{
	import java.lang.*;
	if (!(array is JavaArray)) throw new IllegalArgumentException("Argument is not an array");
	var value:* = JavaArray(array)[index];
	var clazz:Class__ = array.getClass__().getComponentType__();
	if (clazz != Double.TYPE && clazz != Byte.TYPE && clazz != Short.TYPE &&
	clazz != Character.TYPE && clazz != Integer.TYPE && clazz != Long.TYPE &&
	clazz != Float.TYPE)
	{
		throw new IllegalArgumentException("Invalid component type");
	}
	return value;
}*/;

public native static float getFloat(Object array, int index)/*{
	import java.lang.*;
	if (!(array is JavaArray)) throw new IllegalArgumentException("Argument is not an array");
	var value:* = JavaArray(array)[index];
	var clazz:Class__ = array.getClass__().getComponentType__();
	if (clazz != Float.TYPE && clazz != Byte.TYPE && clazz != Short.TYPE &&
	clazz != Character.TYPE && clazz != Integer.TYPE && clazz != Long.TYPE)
	{
		throw new IllegalArgumentException("Invalid component type");
	}
	return value;
}*/;

public native static int getInt(Object array, int index)/*{
	import java.lang.*;
	if (!(array is JavaArray)) throw new IllegalArgumentException("Argument is not an array");
	var value:* = JavaArray(array)[index];
	var clazz:Class__ = array.getClass__().getComponentType__();
	if (clazz != Byte.TYPE && clazz != Short.TYPE &&
	clazz != Character.TYPE && clazz != Integer.TYPE)
	{
		throw new IllegalArgumentException("Invalid component type");
	}
	return value;
}*/;

public native static int getLength(Object array)/*{
	import java.lang.*;
	if (!(array is JavaArray)) throw new IllegalArgumentException();
	return JavaArray(array).length;
}*/;

public native static long getLong(Object array, int index)/*{
	import java.lang.*;
	if (!(array is JavaArray)) throw new IllegalArgumentException("Argument is not an array");
	var value:* = JavaArray(array)[index];
	var clazz:Class__ = array.getClass__().getComponentType__();
	if (clazz != Byte.TYPE && clazz != Short.TYPE &&
	clazz != Character.TYPE && clazz != Integer.TYPE && clazz != Long.TYPE)
	{
		throw new IllegalArgumentException("Invalid component type");
	}
	return value;
}*/;


public native static short getShort(Object array, int index)/*{
	import java.lang.*;
	if (!(array is JavaArray)) throw new IllegalArgumentException("Argument is not an array");
	var value:* = JavaArray(array)[index];
	var clazz:Class__ = array.getClass__().getComponentType__();
	if (clazz != Byte.TYPE && clazz != Short.TYPE)
	{
		throw new IllegalArgumentException("Invalid component type");
	}
	return value;
}*/;

public native static Object newInstance(Class<?> componentType, int length)/*{
	import java.lang.JavaArray;
	return new JavaArray("[" + componentType.getName()).lengths(length);
}*/;

public native static Object newInstance(Class<?> componentType, int[] dimensions)/*{
	import java.lang.JavaArray;
	return new JavaArray("[" + componentType.getName()).lengths(dimensions);
}*/;

public native static void set(Object array, int index, Object value)/*{
	import java.lang.*;
	if (!(array is JavaArray)) throw new IllegalArgumentException("Argument is not an array");
	//TODO check if object can be assigned
	var v:* = value;
	var clazz:Class__ = array.getClass__().getComponentType__();
	if (clazz == Byte.TYPE) v = v[value];
	if (clazz == Boolean__.TYPE) v = v[value];
	if (clazz == Character.TYPE) v = v[value];
	if (clazz == Short.TYPE) v = v[value];
	if (clazz == Integer.TYPE) v = v[value];
	if (clazz == Long.TYPE) v = v[value];
	if (clazz == Double.TYPE) v = v[value];
	if (clazz == Float.TYPE) v = v[value];
	JavaArray(array)[index] = v;
}*/;
}
