/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.util;

public abstract class ListResourceBundle extends ResourceBundle {

public ListResourceBundle()  {
}

protected abstract Object[][] getContents();

public Enumeration getKeys() {
	//TODO handle parent keys
	final Object[][] contents = getContents();
	return new Enumeration() {
		int pos;
		
		public boolean hasMoreElements() {
			return pos < contents.length;
		}

		public Object nextElement() {
			if (pos >= contents.length) throw new NoSuchElementException();
			return contents[pos++];
		}
		
	};
}

public final Object handleGetObject(String key) {
	Object[][] contents = getContents();
	for (int i = 0; i < contents.length; i++) {
		String str = (String)contents[i][0];
		if (str != null && str.equals(key)) {
			return contents[i][1];
		}
	}
	return null;
}
}
