/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.util;

public class Timer {
	
	boolean cancelled;
	
public Timer() {
	this(false);	
}

public Timer(boolean isDaemon) {
}
	
public void cancel() {
	cancelled = true;
}

public void schedule(TimerTask task, Date time) {
	schedule(task, Math.max(0 , time.getTime() - System.currentTimeMillis()));
}

public void schedule(TimerTask task, Date firstTime, long period) {
	schedule(task, Math.max(0 , firstTime.getTime() - System.currentTimeMillis()), period);
}

public void schedule(TimerTask task, long delay) {
	schedule(task, delay, 0);
}

public void schedule(TimerTask task, long delay, long period) {
	if (task.timer != null || task.canceled || cancelled) {
		throw new IllegalStateException();
	}
	task.start(this, delay, period);
}

public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
	scheduleAtFixedRate(task, Math.max(0 , firstTime.getTime() - System.currentTimeMillis()), period);
}

public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
	schedule(task, delay, period);
}
}
