/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.beans;

import java.util.EventObject;

public class PropertyChangeEvent extends EventObject {
	String propertyName;
	Object oldValue;
	Object newValue;
	Object propagationId;
	
public PropertyChangeEvent(Object source, String propertyName, Object oldValue, Object newValue) {
	super(source);
	this.propertyName = propertyName;
	this.newValue = newValue;
	this.oldValue = oldValue;
}

public Object getNewValue() {
	return newValue;
}

public Object getOldValue() {
	return oldValue;
}

public Object getPropagationId() {
	return propagationId;
}

public String getPropertyName() {
	return propertyName;
}

public void setPropagationId(Object propagationId) {
	this.propagationId = propagationId;
}

}
