/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.io;

public class FilterOutputStream extends OutputStream {
	
	protected OutputStream out;
	
public FilterOutputStream(OutputStream out) {
	this.out = out;
}

public void close() throws IOException {
	flush();
	out.close();
}

public void flush() throws IOException {
	out.flush();
}

public void write(byte[] b) throws IOException {
	write(b, 0, b.length);
}

public void write(int b) throws IOException {
	out.write(b);
}

public void write(byte[] b, int off, int len) throws IOException {
	for (int i = off, end = off + len; i < end; i++) {
		write(b[i]);
	}
}

}
