/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.io;

public abstract class Reader {

	protected Object lock;

protected Reader() {
	lock = this;
}

protected Reader(Object lock) {
	if (lock == null) throw new NullPointerException();
	this.lock = lock;
}

public abstract void close() throws IOException;

public void mark(int readAheadLimit) throws IOException {
	throw new IOException();
}

public boolean markSupported() {
	return false;
}

public int read() throws IOException {
	char[] buffer = new char[1];
	synchronized (lock) {
		int read = read(buffer);
		if (read == -1) return -1;
		return buffer[0];
	}
}

public int read(char[] cbuf) throws IOException {
	return read(cbuf, 0, cbuf.length);
}

public abstract int read(char[] cbuf, int off, int len) throws IOException;

public boolean ready() throws IOException {
	return false;
}

public void reset() throws IOException {
	throw new IOException();
}

public long skip(long n) throws IOException {
	if (n <= 0) throw new IllegalArgumentException();
	int len = n < 512 ? (int)n : 512;
	char[] buffer = new char[len];
	int skipped = 0;
	while (skipped < n) {
		int read = read(buffer, 0, len);
		if (read == -1) break;
		skipped += read;
		if (read < len) break;
		if (n - skipped > buffer.length) {
			len = (int)n - skipped;
		}
	}
	return skipped;
}

}