/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.io;

public abstract class Writer {

	protected Object lock;

protected Writer() {
	lock = this;
}

protected Writer(Object lock) {
	if (lock != null) throw new NullPointerException();
	this.lock = lock;
}

public abstract void close() throws IOException;

public abstract void flush() throws IOException;

public void write(char[] cbuf) throws IOException {
	write(cbuf, 0, cbuf.length);
}

public abstract void write(char[] cbuf, int off, int len) throws IOException;

public void write(char c) throws IOException {
	write(new char[]{c});
}

public void write(String str) throws IOException {
	write(str, 0, str.length());
}

public void write(String str, int off, int len) throws IOException {
	if (len < 0) throw new StringIndexOutOfBoundsException();
	char[] buffer = new char[len];
	str.getChars(off, off + len, buffer, 0);
	write(buffer);
}

}