/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang;

public class Thread implements Runnable {
	
	private String name;
	private Runnable runnable;
	private int priority;
	private boolean daemon;
	
	public static final int MAX_PRIORITY = 10;
	
	public static final int MIN_PRIORITY = 1;
	
	public static final int NORM_PRIORITY = 5;
	
	static Thread currentThread;
	
public Thread() {
	this(null, "");
}

public Thread(Runnable runnable) {
	this(runnable, "");
}

public Thread(Runnable runnable, String name) {
	this.runnable = runnable;
	this.name = name;
	this.priority = NORM_PRIORITY;
}

public Thread(String name) {
	this(null, name); 
}
	
public static int activeCount() {
	return 1;
}

public static Thread currentThread() {
	if (currentThread == null) currentThread = new Thread("main");
	return currentThread;
}

public final String getName() {
	return name;
}

public final int getPriority() {
	return priority;
}

public void interrupt() {
}

public final boolean isAlive() {
	return true;
}

public final boolean isDaemon() {
	return daemon;
}

public final void join() throws InterruptedException {
}
	
public void run() {
	if (runnable != null) runnable.run();
}

public final void setPriority(int newPriority) {
	if (!(MIN_PRIORITY <= newPriority && newPriority <= MAX_PRIORITY)) {
		throw new IllegalArgumentException();
	}
	this.priority = newPriority;
}

public static void sleep(long millis) throws InterruptedException {
}

public final void setDaemon(boolean on) {
	this.daemon = on;
}

public void start() {
}

public static void yield() {
}

}
