/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.lang;


import java.io.InputStream;

public abstract class ClassLoader {

static final String base64Table = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

public static InputStream getSystemResourceAsStream(String name) {
	if (name == null) throw new NullPointerException();
	name = mangleResourceName(name);
	String str = getResourceString(name);
	return new java.io.ByteArrayInputStream(decode(str));
}


 private static int getCharValue (char c) {
  if (c == '=') return 0;
  return base64Table.indexOf(c);
}

 private static byte[] decode(String str) {
	int end = str.lastIndexOf('=');
	if (end == -1) end = str.length();
	int pad = str.length() - end;
	byte[] returnArray = new byte[((str.length() / 4) * 3) - pad];
	for (int i=0, k=0; i<str.length(); i+=4, k+=3) {
		int c = getCharValue(str.charAt(i))<<18;
		c |= getCharValue(str.charAt(i+1))<<12;
		c |= getCharValue(str.charAt(i+2))<<6;
		c |= getCharValue(str.charAt(i+3));
		for (int j = 2; j >= 0; j--) {
			if (k + j < returnArray.length) {
				returnArray[k + j] = (byte) (c & 0xff);
			}
			c >>= 8;
		}
	}
	return returnArray;
}
	

static String mangleResourceName (String tempString) {
	String mangledName = tempString.replace(' ','_');
	mangledName = mangledName.replace('/', '_');
	mangledName = mangledName.replace('.', '_');
	mangledName = mangledName.replace('-', '_');
	return mangledName;
}

static native String getResourceString(String name)/*-{
	return $wnd[name];
}-*/;

}
