/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package java.util;

import java.io.IOException;
import java.io.InputStream;

public class PropertyResourceBundle extends ResourceBundle {

	Properties properties;
	
public PropertyResourceBundle(InputStream stream) throws IOException {
	properties = new Properties();
	properties.load(stream);
}

public Enumeration getKeys() {
	//TODO handle parent keys
	return properties.keys();
}

protected Object handleGetObject(String key) {
	return properties.getProperty(key);
}


}
