package org.eclipse.swt.examples.controlexample {
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.swt.*;
import org.eclipse.swt.browser.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.MessageBox;
import java.lang.StringBuffer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.VisibilityWindowListener;
import java.lang.Arguments;
import java.lang.Class__;
import java.lang.JavaArray;
dynamic public class BrowserTab extends Tab {
  internal var browser: Browser;
  internal var browserGroup: Group;
  internal var mozillaButton: Button;
  internal var errorMessage: String;
  internal var lastText: String;
  internal var lastUrl: String;
  function BrowserTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createBackgroundModeGroup__(): void {
  }
  public override function createColorAndFontGroup__(): void {
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    browserGroup = new Group(exampleGroup, 0);
    browserGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    browserGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    browserGroup.setText__Ljava_lang_String_2("Browser");
    return;
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (borderButton.getSelection__())
      style |= 2048;
    if (mozillaButton.getSelection__())
      style |= 32768;
    try {
      browser = new Browser(browserGroup, style);
    } catch (e : SWTError) {
      try {
        browser = new Browser(browserGroup, style & ~32768);
      } catch (e2 : SWTError) {
        errorMessage = e.getMessage__();
        return;
      }
      var dialog: MessageBox = new MessageBox(new Arguments(org.eclipse.swt.widgets.MessageBox.MessageBox__Lorg_eclipse_swt_widgets_Shell_2I, [shell, 8 | 32]));
      dialog.setMessage__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2_3Ljava_lang_Object_2("MozillaNotFound", new JavaArray("[Ljava/lang/String;").values(e.getMessage__())));
      dialog.open__();
    }
    if (lastUrl !== null) {
      browser.setUrl__Ljava_lang_String_2(lastUrl);
    } else if (lastText !== null) {
      browser.setText__Ljava_lang_String_2(lastText);
    } else {
      var htmlStream: InputStream = Class__.forName__Ljava_lang_String_2("org.eclipse.swt.examples.controlexample.ControlExample").getResourceAsStream__Ljava_lang_String_2("browser-content.html");
      var br: BufferedReader = new BufferedReader(new Arguments(java.io.BufferedReader.BufferedReader__Ljava_io_Reader_2, [new InputStreamReader(new Arguments(java.io.InputStreamReader.InputStreamReader__Ljava_io_InputStream_2, [htmlStream]))]));
      var sb: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__I, [300]));
      try {
        var read: int = 0;
        while ((read = br.read__()) != -1)
          sb.append__C(uint(read));
      } catch (e_1 : IOException) {
        this.log__Ljava_lang_String_2(e_1.getMessage__());
      } finally {
        try {
          br.close__();
        } catch (e_2 : IOException) {
          this.log__Ljava_lang_String_2(e_2.getMessage__());
        }
      }
      var text: String = sb.toString__();
      browser.setText__Ljava_lang_String_2(text);
    }
    lastText = lastUrl = null;
    return;
  }
  public override function createOtherGroup__(): void {
    super.createOtherGroup__();
    backgroundImageButton.dispose__();
    return;
  }
  public override function createSizeGroup__(): void {
    super.createSizeGroup__();
    fillHButton.setSelection__Z(true);
    fillVButton.setSelection__Z(true);
    return;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    mozillaButton = new Button(styleGroup, 32);
    mozillaButton.setText__Ljava_lang_String_2("SWT.MOZILLA");
    borderButton = new Button(styleGroup, 32);
    borderButton.setText__Ljava_lang_String_2("SWT.BORDER");
    return;
  }
  public override function createTabFolderPage__Lorg_eclipse_swt_widgets_TabFolder_2(tabFolder: TabFolder): Composite {
    super.createTabFolderPage__Lorg_eclipse_swt_widgets_TabFolder_2(tabFolder);
    tabFolderPage.addControlListener__Lorg_eclipse_swt_events_ControlListener_2(new org.eclipse.swt.examples.controlexample.BrowserTab$1(this));
    tabFolder.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.BrowserTab$2(this, tabFolder));
    return tabFolderPage;
  }
  public override function disposeExampleWidgets__(): void {
    if (browser !== null) {
      var url: String = browser.getUrl__();
      if (Object(url).length__() > 0 && !Object(url).equals__Ljava_lang_Object_2("about:blank")) {
        lastUrl = url;
      } else {
        var text: String = browser.getText__();
        if (Object(text).length__() > 0) {
          lastText = text;
        }
      }
    }
    super.disposeExampleWidgets__();
    return;
  }
  public static function getContents__Ljava_io_InputStream_2(in_1: InputStream): String {
    var br: BufferedReader = new BufferedReader(new Arguments(java.io.BufferedReader.BufferedReader__Ljava_io_Reader_2, [new InputStreamReader(new Arguments(java.io.InputStreamReader.InputStreamReader__Ljava_io_InputStream_2, [in_1]))]));
    var sb: StringBuffer = new StringBuffer(new Arguments(java.lang.StringBuffer.StringBuffer__I, [300]));
    try {
      var read: int = 0;
      while ((read = br.read__()) != -1)
        sb.append__C(uint(read));
    } finally {
      br.close__();
    }
    return sb.toString__();
  }
  public override function getCustomEventNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("CloseWindowListener", "LocationListener", "OpenWindowListener", "ProgressListener", "StatusTextListener", "TitleListener", "VisibilityWindowListener");
  }
  public override function getExampleWidgets__(): JavaArray {
    if (browser !== null)
      return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(browser);
    return super.getExampleWidgets__();
  }
  public override function getMethodNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("Text", "Url", "ToolTipText");
  }
  public override function getTabText__(): String {
    return "Browser";
  }
  public override function hookCustomListener__Ljava_lang_String_2(eventName: String): void {
    if (browser === null)
      return;
    if (eventName === "CloseWindowListener") {
      browser.addCloseWindowListener__Lorg_eclipse_swt_browser_CloseWindowListener_2(new org.eclipse.swt.examples.controlexample.BrowserTab$3(this, eventName));
    }
    if (eventName === "LocationListener") {
      browser.addLocationListener__Lorg_eclipse_swt_browser_LocationListener_2(new org.eclipse.swt.examples.controlexample.BrowserTab$4(this, eventName));
    }
    if (eventName === "OpenWindowListener") {
      browser.addOpenWindowListener__Lorg_eclipse_swt_browser_OpenWindowListener_2(new org.eclipse.swt.examples.controlexample.BrowserTab$5(this, eventName));
    }
    if (eventName === "ProgressListener") {
      browser.addProgressListener__Lorg_eclipse_swt_browser_ProgressListener_2(new org.eclipse.swt.examples.controlexample.BrowserTab$6(this, eventName));
    }
    if (eventName === "StatusTextListener") {
      browser.addStatusTextListener__Lorg_eclipse_swt_browser_StatusTextListener_2(new org.eclipse.swt.examples.controlexample.BrowserTab$7(this, eventName));
    }
    if (eventName === "TitleListener") {
      browser.addTitleListener__Lorg_eclipse_swt_browser_TitleListener_2(new org.eclipse.swt.examples.controlexample.BrowserTab$8(this, eventName));
    }
    if (eventName === "VisibilityWindowListener") {
      browser.addVisibilityWindowListener__Lorg_eclipse_swt_browser_VisibilityWindowListener_2(new org.eclipse.swt.examples.controlexample.BrowserTab$9(this, eventName));
    }
    return;
  }
  public override function rtlSupport__(): Boolean {
    return false;
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    mozillaButton.setSelection__Z(browser === null ? false : (browser.getStyle__() & 32768) != 0);
    borderButton.setSelection__Z(browser === null ? false : (browser.getStyle__() & 2048) != 0);
  }
}
}
