package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Widget;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ButtonTab extends AlignableTab {
  internal var button1: Button;
  internal var button2: Button;
  internal var button3: Button;
  internal var button4: Button;
  internal var button5: Button;
  internal var button6: Button;
  internal var button7: Button;
  internal var button8: Button;
  internal var button9: Button;
  internal var textButtonGroup: Group;
  internal var imageButtonGroup: Group;
  internal var imagetextButtonGroup: Group;
  internal var upButton: Button;
  internal var downButton: Button;
  internal var pushButton: Button;
  internal var checkButton: Button;
  internal var radioButton: Button;
  internal var toggleButton: Button;
  internal var arrowButton: Button;
  internal var flatButton: Button;
  function ButtonTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createControlGroup__(): void {
    super.createControlGroup__();
    upButton = new Button(alignmentGroup, 16);
    upButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Up"));
    downButton = new Button(alignmentGroup, 16);
    downButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Down"));
    var selectionListener: SelectionListener = new org.eclipse.swt.examples.controlexample.ButtonTab$1(this);
    upButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(selectionListener);
    downButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(selectionListener);
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    textButtonGroup = new Group(exampleGroup, 0);
    var gridLayout: GridLayout = new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, []));
    textButtonGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(gridLayout);
    gridLayout.numColumns = 3;
    textButtonGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    textButtonGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Text_Buttons"));
    imageButtonGroup = new Group(exampleGroup, 0);
    gridLayout = new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, []));
    imageButtonGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(gridLayout);
    gridLayout.numColumns = 3;
    imageButtonGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    imageButtonGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Image_Buttons"));
    imagetextButtonGroup = new Group(exampleGroup, 0);
    gridLayout = new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, []));
    imagetextButtonGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(gridLayout);
    gridLayout.numColumns = 3;
    imagetextButtonGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    imagetextButtonGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Image_Text_Buttons"));
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (pushButton.getSelection__())
      style |= 8;
    if (checkButton.getSelection__())
      style |= 32;
    if (radioButton.getSelection__())
      style |= 16;
    if (toggleButton.getSelection__())
      style |= 2;
    if (flatButton.getSelection__())
      style |= 8388608;
    if (borderButton.getSelection__())
      style |= 2048;
    if (leftButton.getSelection__())
      style |= 16384;
    if (rightButton.getSelection__())
      style |= 131072;
    if (arrowButton.getSelection__()) {
      style |= 4;
      if (upButton.getSelection__())
        style |= 128;
      if (downButton.getSelection__())
        style |= 1024;
    } else {
      if (centerButton.getSelection__())
        style |= 16777216;
    }
    button1 = new Button(textButtonGroup, style);
    button1.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("One"));
    button2 = new Button(textButtonGroup, style);
    button2.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Two"));
    button3 = new Button(textButtonGroup, style);
    button3.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Three"));
    button4 = new Button(imageButtonGroup, style);
    button4.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
    button5 = new Button(imageButtonGroup, style);
    button5.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[1]);
    button6 = new Button(imageButtonGroup, style);
    button6.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[2]);
    button7 = new Button(imagetextButtonGroup, style);
    button7.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("One"));
    button7.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
    button8 = new Button(imagetextButtonGroup, style);
    button8.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Two"));
    button8.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[1]);
    button9 = new Button(imagetextButtonGroup, style);
    button9.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Three"));
    button9.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[2]);
    return;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    pushButton = new Button(styleGroup, 16);
    pushButton.setText__Ljava_lang_String_2("SWT.PUSH");
    checkButton = new Button(styleGroup, 16);
    checkButton.setText__Ljava_lang_String_2("SWT.CHECK");
    radioButton = new Button(styleGroup, 16);
    radioButton.setText__Ljava_lang_String_2("SWT.RADIO");
    toggleButton = new Button(styleGroup, 16);
    toggleButton.setText__Ljava_lang_String_2("SWT.TOGGLE");
    arrowButton = new Button(styleGroup, 16);
    arrowButton.setText__Ljava_lang_String_2("SWT.ARROW");
    flatButton = new Button(styleGroup, 32);
    flatButton.setText__Ljava_lang_String_2("SWT.FLAT");
    borderButton = new Button(styleGroup, 32);
    borderButton.setText__Ljava_lang_String_2("SWT.BORDER");
    return;
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(button1, button2, button3, button4, button5, button6, button7, button8, button9);
  }
  public override function getMethodNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("Grayed", "Selection", "Text", "ToolTipText");
  }
  public override function getTabText__(): String {
    return "Button";
  }
  public override function setExampleWidgetAlignment__(): void {
    var alignment: int = 0;
    if (leftButton.getSelection__())
      alignment = 16384;
    if (centerButton.getSelection__())
      alignment = 16777216;
    if (rightButton.getSelection__())
      alignment = 131072;
    if (upButton.getSelection__())
      alignment = 128;
    if (downButton.getSelection__())
      alignment = 1024;
    button1.setAlignment__I(alignment);
    button2.setAlignment__I(alignment);
    button3.setAlignment__I(alignment);
    button4.setAlignment__I(alignment);
    button5.setAlignment__I(alignment);
    button6.setAlignment__I(alignment);
    button7.setAlignment__I(alignment);
    button8.setAlignment__I(alignment);
    button9.setAlignment__I(alignment);
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    if (arrowButton.getSelection__()) {
      upButton.setEnabled__Z(true);
      centerButton.setEnabled__Z(false);
      downButton.setEnabled__Z(true);
    } else {
      upButton.setEnabled__Z(false);
      centerButton.setEnabled__Z(true);
      downButton.setEnabled__Z(false);
    }
    upButton.setSelection__Z((button1.getStyle__() & 128) != 0);
    downButton.setSelection__Z((button1.getStyle__() & 1024) != 0);
    pushButton.setSelection__Z((button1.getStyle__() & 8) != 0);
    checkButton.setSelection__Z((button1.getStyle__() & 32) != 0);
    radioButton.setSelection__Z((button1.getStyle__() & 16) != 0);
    toggleButton.setSelection__Z((button1.getStyle__() & 2) != 0);
    arrowButton.setSelection__Z((button1.getStyle__() & 4) != 0);
    flatButton.setSelection__Z((button1.getStyle__() & 8388608) != 0);
    borderButton.setSelection__Z((button1.getStyle__() & 2048) != 0);
    return;
  }
}
}
