package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Widget;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class CComboTab extends Tab {
  internal var combo1: CCombo;
  internal var comboGroup: Group;
  internal var flatButton: Button;
  internal var readOnlyButton: Button;
  public static var ListData: JavaArray = new JavaArray("[Ljava/lang/String;").values(ControlExample.getResourceString__Ljava_lang_String_2("ListData1_0"), ControlExample.getResourceString__Ljava_lang_String_2("ListData1_1"), ControlExample.getResourceString__Ljava_lang_String_2("ListData1_2"), ControlExample.getResourceString__Ljava_lang_String_2("ListData1_3"), ControlExample.getResourceString__Ljava_lang_String_2("ListData1_4"), ControlExample.getResourceString__Ljava_lang_String_2("ListData1_5"), ControlExample.getResourceString__Ljava_lang_String_2("ListData1_6"), ControlExample.getResourceString__Ljava_lang_String_2("ListData1_7"), ControlExample.getResourceString__Ljava_lang_String_2("ListData1_8"));
  function CComboTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    comboGroup = new Group(exampleGroup, 0);
    comboGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    comboGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    comboGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Custom_Combo"));
    return;
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (flatButton.getSelection__())
      style |= 8388608;
    if (readOnlyButton.getSelection__())
      style |= 8;
    if (borderButton.getSelection__())
      style |= 2048;
    combo1 = new CCombo(comboGroup, style);
    combo1.setItems___3Ljava_lang_String_2(ListData);
    if (ListData.length >= 3) {
      combo1.setText__Ljava_lang_String_2(ListData[2]);
    }
    return;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    readOnlyButton = new Button(styleGroup, 32);
    readOnlyButton.setText__Ljava_lang_String_2("SWT.READ_ONLY");
    borderButton = new Button(styleGroup, 32);
    borderButton.setText__Ljava_lang_String_2("SWT.BORDER");
    flatButton = new Button(styleGroup, 32);
    flatButton.setText__Ljava_lang_String_2("SWT.FLAT");
    return;
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(combo1);
  }
  public override function getMethodNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("Editable", "Items", "Selection", "Text", "TextLimit", "ToolTipText", "VisibleItemCount");
  }
  public override function getTabText__(): String {
    return "CCombo";
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    flatButton.setSelection__Z((combo1.getStyle__() & 8388608) != 0);
    readOnlyButton.setSelection__Z((combo1.getStyle__() & 8) != 0);
    borderButton.setSelection__Z((combo1.getStyle__() & 2048) != 0);
  }
}
}
