package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Widget;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class CLabelTab extends AlignableTab {
  internal var label1: CLabel;
  internal var label2: CLabel;
  internal var label3: CLabel;
  internal var textLabelGroup: Group;
  internal var shadowInButton: Button;
  internal var shadowOutButton: Button;
  internal var shadowNoneButton: Button;
  function CLabelTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    textLabelGroup = new Group(exampleGroup, 0);
    var gridLayout: GridLayout = new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, []));
    textLabelGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(gridLayout);
    gridLayout.numColumns = 3;
    textLabelGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    textLabelGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Custom_Labels"));
    return;
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (shadowInButton.getSelection__())
      style |= 4;
    if (shadowNoneButton.getSelection__())
      style |= 32;
    if (shadowOutButton.getSelection__())
      style |= 8;
    if (leftButton.getSelection__())
      style |= 16384;
    if (centerButton.getSelection__())
      style |= 16777216;
    if (rightButton.getSelection__())
      style |= 131072;
    label1 = new CLabel(textLabelGroup, style);
    label1.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("One"));
    label1.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
    label2 = new CLabel(textLabelGroup, style);
    label2.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[2]);
    label3 = new CLabel(textLabelGroup, style);
    label3.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Example_string") + "\n" + ControlExample.getResourceString__Ljava_lang_String_2("One_Two_Three"));
    return;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    shadowNoneButton = new Button(styleGroup, 16);
    shadowNoneButton.setText__Ljava_lang_String_2("SWT.SHADOW_NONE");
    shadowInButton = new Button(styleGroup, 16);
    shadowInButton.setText__Ljava_lang_String_2("SWT.SHADOW_IN");
    shadowOutButton = new Button(styleGroup, 16);
    shadowOutButton.setText__Ljava_lang_String_2("SWT.SHADOW_OUT");
    return;
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(label1, label2, label3);
  }
  public override function getMethodNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("Text", "ToolTipText");
  }
  public override function getTabText__(): String {
    return "CLabel";
  }
  public override function setExampleWidgetAlignment__(): void {
    var alignment: int = 0;
    if (leftButton.getSelection__())
      alignment = 16384;
    if (centerButton.getSelection__())
      alignment = 16777216;
    if (rightButton.getSelection__())
      alignment = 131072;
    label1.setAlignment__I(alignment);
    label2.setAlignment__I(alignment);
    label3.setAlignment__I(alignment);
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    leftButton.setSelection__Z((label1.getStyle__() & 16384) != 0);
    centerButton.setSelection__Z((label1.getStyle__() & 16777216) != 0);
    rightButton.setSelection__Z((label1.getStyle__() & 131072) != 0);
    shadowInButton.setSelection__Z((label1.getStyle__() & 4) != 0);
    shadowOutButton.setSelection__Z((label1.getStyle__() & 8) != 0);
    shadowNoneButton.setSelection__Z((label1.getStyle__() & (4 | 8)) == 0);
  }
}
}
