package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.graphics.Image;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class CTabFolderTab extends Tab {
  internal var lastSelectedTab: int = 0;
  internal var tabFolder1: CTabFolder;
  internal var tabFolderGroup: Group;
  internal var itemGroup: Group;
  internal var topButton: Button;
  internal var bottomButton: Button;
  internal var flatButton: Button;
  internal var closeButton: Button;
  public static var CTabItems1: JavaArray = new JavaArray("[Ljava/lang/String;").values(ControlExample.getResourceString__Ljava_lang_String_2("CTabItem1_0"), ControlExample.getResourceString__Ljava_lang_String_2("CTabItem1_1"), ControlExample.getResourceString__Ljava_lang_String_2("CTabItem1_2"));
  public static const SELECTION_FOREGROUND_COLOR: int = 3;
  public static const SELECTION_BACKGROUND_COLOR: int = 4;
  public static const ITEM_FONT: int = 5;
  internal var selectionForegroundColor: Color;
  internal var selectionBackgroundColor: Color;
  internal var itemFont: Font;
  internal var simpleTabButton: Button;
  internal var singleTabButton: Button;
  internal var imageButton: Button;
  internal var showMinButton: Button;
  internal var showMaxButton: Button;
  internal var unselectedCloseButton: Button;
  internal var unselectedImageButton: Button;
  function CTabFolderTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createColorAndFontGroup__(): void {
    super.createColorAndFontGroup__();
    var item: TableItem = new TableItem(new Arguments(org.eclipse.swt.widgets.TableItem.TableItem__Lorg_eclipse_swt_widgets_Table_2I, [colorAndFontTable, 0]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Selection_Foreground_Color"));
    item = new TableItem(new Arguments(org.eclipse.swt.widgets.TableItem.TableItem__Lorg_eclipse_swt_widgets_Table_2I, [colorAndFontTable, 0]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Selection_Background_Color"));
    item = new TableItem(new Arguments(org.eclipse.swt.widgets.TableItem.TableItem__Lorg_eclipse_swt_widgets_Table_2I, [colorAndFontTable, 0]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Item_Font"));
    shell.addDisposeListener__Lorg_eclipse_swt_events_DisposeListener_2(new org.eclipse.swt.examples.controlexample.CTabFolderTab$1(this));
    return;
  }
  public override function changeFontOrColor__I(index: int): void {
    switch (index) {
      case 3 :
        {
          var oldColor: Color = selectionForegroundColor;
          if (oldColor === null)
            oldColor = tabFolder1.getSelectionForeground__();
          colorDialog.setRGB__Lorg_eclipse_swt_graphics_RGB_2(oldColor.getRGB__());
          var rgb: RGB = colorDialog.open__();
          if (rgb === null)
            return;
          oldColor = selectionForegroundColor;
          selectionForegroundColor = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_RGB_2, [display, rgb]));
          this.setSelectionForeground__();
          if (oldColor !== null)
            oldColor.dispose__();
        }
        break;
      case 4 :
        {
          var oldColor_1: Color = selectionBackgroundColor;
          if (oldColor_1 === null)
            oldColor_1 = tabFolder1.getSelectionBackground__();
          colorDialog.setRGB__Lorg_eclipse_swt_graphics_RGB_2(oldColor_1.getRGB__());
          var rgb_1: RGB = colorDialog.open__();
          if (rgb_1 === null)
            return;
          oldColor_1 = selectionBackgroundColor;
          selectionBackgroundColor = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_RGB_2, [display, rgb_1]));
          this.setSelectionBackground__();
          if (oldColor_1 !== null)
            oldColor_1.dispose__();
        }
        break;
      case 5 :
        {
          var oldFont: Font = itemFont;
          if (oldFont === null)
            oldFont = tabFolder1.getItem__I(0).getFont__();
          fontDialog.setFontList___3Lorg_eclipse_swt_graphics_FontData_2(oldFont.getFontData__());
          var fontData: FontData = fontDialog.open__();
          if (fontData === null)
            return;
          oldFont = itemFont;
          itemFont = new Font(new Arguments(org.eclipse.swt.graphics.Font.Font__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_FontData_2, [display, fontData]));
          this.setItemFont__();
          this.setExampleWidgetSize__();
          if (oldFont !== null)
            oldFont.dispose__();
        }
        break;
      default :
        super.changeFontOrColor__I(index);
    }
    return;
  }
  public override function createOtherGroup__(): void {
    super.createOtherGroup__();
    simpleTabButton = new Button(otherGroup, 32);
    simpleTabButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Set_Simple_Tabs"));
    simpleTabButton.setSelection__Z(true);
    simpleTabButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.CTabFolderTab$2(this));
    singleTabButton = new Button(otherGroup, 32);
    singleTabButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Set_Single_Tabs"));
    singleTabButton.setSelection__Z(false);
    singleTabButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.CTabFolderTab$3(this));
    showMinButton = new Button(otherGroup, 32);
    showMinButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Set_Min_Visible"));
    showMinButton.setSelection__Z(false);
    showMinButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.CTabFolderTab$4(this));
    showMaxButton = new Button(otherGroup, 32);
    showMaxButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Set_Max_Visible"));
    showMaxButton.setSelection__Z(false);
    showMaxButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.CTabFolderTab$5(this));
    imageButton = new Button(otherGroup, 32);
    imageButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Set_Image"));
    imageButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.CTabFolderTab$6(this));
    unselectedImageButton = new Button(otherGroup, 32);
    unselectedImageButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Set_Unselected_Image_Visible"));
    unselectedImageButton.setSelection__Z(true);
    unselectedImageButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.CTabFolderTab$7(this));
    unselectedCloseButton = new Button(otherGroup, 32);
    unselectedCloseButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Set_Unselected_Close_Visible"));
    unselectedCloseButton.setSelection__Z(true);
    unselectedCloseButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.CTabFolderTab$8(this));
    return;
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    tabFolderGroup = new Group(exampleGroup, 0);
    tabFolderGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    tabFolderGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    tabFolderGroup.setText__Ljava_lang_String_2("CTabFolder");
    return;
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (topButton.getSelection__())
      style |= 128;
    if (bottomButton.getSelection__())
      style |= 1024;
    if (borderButton.getSelection__())
      style |= 2048;
    if (flatButton.getSelection__())
      style |= 8388608;
    if (closeButton.getSelection__())
      style |= 64;
    tabFolder1 = new CTabFolder(tabFolderGroup, style);
    for (var i: int = 0; i < CTabItems1.length; i++) {
      var item: CTabItem = new CTabItem(new Arguments(org.eclipse.swt.custom.CTabItem.CTabItem__Lorg_eclipse_swt_custom_CTabFolder_2I, [tabFolder1, 0]));
      item.setText__Ljava_lang_String_2(CTabItems1[i]);
      var text: Text = new Text(tabFolder1, 64 | 2);
      text.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("CTabItem_content") + ": " + i);
      item.setControl__Lorg_eclipse_swt_widgets_Control_2(text);
    }
    tabFolder1.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, new org.eclipse.swt.examples.controlexample.CTabFolderTab$9(this));
    tabFolder1.setSelection__I(lastSelectedTab);
    return;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    topButton = new Button(styleGroup, 16);
    topButton.setText__Ljava_lang_String_2("SWT.TOP");
    topButton.setSelection__Z(true);
    bottomButton = new Button(styleGroup, 16);
    bottomButton.setText__Ljava_lang_String_2("SWT.BOTTOM");
    borderButton = new Button(styleGroup, 32);
    borderButton.setText__Ljava_lang_String_2("SWT.BORDER");
    flatButton = new Button(styleGroup, 32);
    flatButton.setText__Ljava_lang_String_2("SWT.FLAT");
    closeButton = new Button(styleGroup, 32);
    closeButton.setText__Ljava_lang_String_2("SWT.CLOSE");
    return;
  }
  public override function getCustomEventNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("CTabFolderEvent");
  }
  public override function getExampleWidgetItems__(): JavaArray {
    return tabFolder1.getItems__();
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(tabFolder1);
  }
  public override function getTabText__(): String {
    return "CTabFolder";
  }
  public override function hookCustomListener__Ljava_lang_String_2(eventName: String): void {
    if (eventName === "CTabFolderEvent") {
      tabFolder1.addCTabFolder2Listener__Lorg_eclipse_swt_custom_CTabFolder2Listener_2(new org.eclipse.swt.examples.controlexample.CTabFolderTab$10(this, eventName));
    }
    return;
  }
  public override function resetColorsAndFonts__(): void {
    super.resetColorsAndFonts__();
    var oldColor: Color = selectionForegroundColor;
    selectionForegroundColor = null;
    this.setSelectionForeground__();
    if (oldColor !== null)
      oldColor.dispose__();
    oldColor = selectionBackgroundColor;
    selectionBackgroundColor = null;
    this.setSelectionBackground__();
    if (oldColor !== null)
      oldColor.dispose__();
    var oldFont: Font = itemFont;
    itemFont = null;
    this.setItemFont__();
    if (oldFont !== null)
      oldFont.dispose__();
    return;
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    this.setSimpleTabs__();
    this.setSingleTabs__();
    this.setImages__();
    this.setMinimizeVisible__();
    this.setMaximizeVisible__();
    this.setUnselectedCloseVisible__();
    this.setUnselectedImageVisible__();
    this.setSelectionBackground__();
    this.setSelectionForeground__();
    this.setItemFont__();
    this.setExampleWidgetSize__();
    return;
  }
  public function setSimpleTabs__(): void {
    tabFolder1.setSimple__Z(simpleTabButton.getSelection__());
    this.setExampleWidgetSize__();
    return;
  }
  public function setSingleTabs__(): void {
    tabFolder1.setSingle__Z(singleTabButton.getSelection__());
    this.setExampleWidgetSize__();
    return;
  }
  public function setImages__(): void {
    var setImage: Boolean = imageButton.getSelection__();
    var items: JavaArray = tabFolder1.getItems__();
    for (var i: int = 0; i < items.length; i++) {
      if (setImage) {
        items[i].setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
      } else {
        items[i].setImage__Lorg_eclipse_swt_graphics_Image_2(null);
      }
    }
    this.setExampleWidgetSize__();
    return;
  }
  public function setMinimizeVisible__(): void {
    tabFolder1.setMinimizeVisible__Z(showMinButton.getSelection__());
    this.setExampleWidgetSize__();
    return;
  }
  public function setMaximizeVisible__(): void {
    tabFolder1.setMaximizeVisible__Z(showMaxButton.getSelection__());
    this.setExampleWidgetSize__();
    return;
  }
  public function setUnselectedCloseVisible__(): void {
    tabFolder1.setUnselectedCloseVisible__Z(unselectedCloseButton.getSelection__());
    this.setExampleWidgetSize__();
    return;
  }
  public function setUnselectedImageVisible__(): void {
    tabFolder1.setUnselectedImageVisible__Z(unselectedImageButton.getSelection__());
    this.setExampleWidgetSize__();
    return;
  }
  public function setSelectionBackground__(): void {
    if (!instance.startup) {
      tabFolder1.setSelectionBackground__Lorg_eclipse_swt_graphics_Color_2(selectionBackgroundColor);
    }
    var color: Color = selectionBackgroundColor;
    if (color === null)
      color = tabFolder1.getSelectionBackground__();
    var item: TableItem = colorAndFontTable.getItem__I(4);
    var oldImage: Image = item.getImage__();
    if (oldImage !== null)
      oldImage.dispose__();
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(this.colorImage__Lorg_eclipse_swt_graphics_Color_2(color));
    return;
  }
  public function setSelectionForeground__(): void {
    if (!instance.startup) {
      tabFolder1.setSelectionForeground__Lorg_eclipse_swt_graphics_Color_2(selectionForegroundColor);
    }
    var color: Color = selectionForegroundColor;
    if (color === null)
      color = tabFolder1.getSelectionForeground__();
    var item: TableItem = colorAndFontTable.getItem__I(3);
    var oldImage: Image = item.getImage__();
    if (oldImage !== null)
      oldImage.dispose__();
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(this.colorImage__Lorg_eclipse_swt_graphics_Color_2(color));
    return;
  }
  public function setItemFont__(): void {
    if (!instance.startup) {
      tabFolder1.getItem__I(0).setFont__Lorg_eclipse_swt_graphics_Font_2(itemFont);
      this.setExampleWidgetSize__();
    }
    var ft: Font = itemFont;
    if (ft === null)
      ft = tabFolder1.getItem__I(0).getFont__();
    var item: TableItem = colorAndFontTable.getItem__I(5);
    var oldImage: Image = item.getImage__();
    if (oldImage !== null)
      oldImage.dispose__();
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(this.fontImage__Lorg_eclipse_swt_graphics_Font_2(ft));
    item.setFont__Lorg_eclipse_swt_graphics_Font_2(ft);
    colorAndFontTable.layout__();
    return;
  }
}
}
