package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.graphics.Font;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class CanvasTab extends Tab {
  public static var colors: JavaArray = new JavaArray("[I").values(3, 5, 9, 11, 7, 13, 4, 6, 10, 12, 8, 14);
  public static const canvasString: String = "Canvas";
  internal var canvas: Canvas;
  internal var canvasGroup: Group;
  internal var horizontalButton: Button;
  internal var verticalButton: Button;
  internal var noBackgroundButton: Button;
  internal var noFocusButton: Button;
  internal var noMergePaintsButton: Button;
  internal var noRedrawResizeButton: Button;
  internal var doubleBufferedButton: Button;
  internal var caretButton: Button;
  internal var fillDamageButton: Button;
  internal var paintCount: int;
  internal var cx: int;
  internal var cy: int;
  internal var maxX: int;
  internal var maxY: int;
  function CanvasTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createOtherGroup__(): void {
    super.createOtherGroup__();
    caretButton = new Button(otherGroup, 32);
    caretButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Caret"));
    fillDamageButton = new Button(otherGroup, 32);
    fillDamageButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("FillDamage"));
    caretButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.CanvasTab$1(this));
    return;
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    canvasGroup = new Group(exampleGroup, 0);
    canvasGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    canvasGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    canvasGroup.setText__Ljava_lang_String_2("Canvas");
    return;
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (horizontalButton.getSelection__())
      style |= 256;
    if (verticalButton.getSelection__())
      style |= 512;
    if (borderButton.getSelection__())
      style |= 2048;
    if (noBackgroundButton.getSelection__())
      style |= 262144;
    if (noFocusButton.getSelection__())
      style |= 524288;
    if (noMergePaintsButton.getSelection__())
      style |= 2097152;
    if (noRedrawResizeButton.getSelection__())
      style |= 1048576;
    if (doubleBufferedButton.getSelection__())
      style |= 536870912;
    paintCount = 0;
    cx = 0;
    cy = 0;
    canvas = new Canvas(new Arguments(org.eclipse.swt.widgets.Canvas.Canvas__Lorg_eclipse_swt_widgets_Composite_2I, [canvasGroup, style]));
    canvas.addPaintListener__Lorg_eclipse_swt_events_PaintListener_2(new org.eclipse.swt.examples.controlexample.CanvasTab$2(this));
    canvas.addControlListener__Lorg_eclipse_swt_events_ControlListener_2(new org.eclipse.swt.examples.controlexample.CanvasTab$3(this));
    var bar: ScrollBar = canvas.getHorizontalBar__();
    if (bar !== null) {
      this.hookListeners__Lorg_eclipse_swt_widgets_Widget_2(bar);
      bar.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.CanvasTab$4(this));
    }
    bar = canvas.getVerticalBar__();
    if (bar !== null) {
      this.hookListeners__Lorg_eclipse_swt_widgets_Widget_2(bar);
      bar.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.CanvasTab$5(this));
    }
    return;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    horizontalButton = new Button(styleGroup, 32);
    horizontalButton.setText__Ljava_lang_String_2("SWT.H_SCROLL");
    horizontalButton.setSelection__Z(true);
    verticalButton = new Button(styleGroup, 32);
    verticalButton.setText__Ljava_lang_String_2("SWT.V_SCROLL");
    verticalButton.setSelection__Z(true);
    borderButton = new Button(styleGroup, 32);
    borderButton.setText__Ljava_lang_String_2("SWT.BORDER");
    noBackgroundButton = new Button(styleGroup, 32);
    noBackgroundButton.setText__Ljava_lang_String_2("SWT.NO_BACKGROUND");
    noFocusButton = new Button(styleGroup, 32);
    noFocusButton.setText__Ljava_lang_String_2("SWT.NO_FOCUS");
    noMergePaintsButton = new Button(styleGroup, 32);
    noMergePaintsButton.setText__Ljava_lang_String_2("SWT.NO_MERGE_PAINTS");
    noRedrawResizeButton = new Button(styleGroup, 32);
    noRedrawResizeButton.setText__Ljava_lang_String_2("SWT.NO_REDRAW_RESIZE");
    doubleBufferedButton = new Button(styleGroup, 32);
    doubleBufferedButton.setText__Ljava_lang_String_2("SWT.DOUBLE_BUFFERED");
    return;
  }
  public override function createTabFolderPage__Lorg_eclipse_swt_widgets_TabFolder_2(tabFolder: TabFolder): Composite {
    super.createTabFolderPage__Lorg_eclipse_swt_widgets_TabFolder_2(tabFolder);
    tabFolderPage.addControlListener__Lorg_eclipse_swt_events_ControlListener_2(new org.eclipse.swt.examples.controlexample.CanvasTab$6(this));
    return tabFolderPage;
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(canvas);
  }
  public override function getMethodNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("ToolTipText");
  }
  public override function getTabText__(): String {
    return "Canvas";
  }
  public function resizeScrollBars__(): void {
    var clientArea: Rectangle = canvas.getClientArea__();
    var bar: ScrollBar = canvas.getHorizontalBar__();
    if (bar !== null) {
      bar.setMaximum__I(maxX);
      bar.setThumb__I(clientArea.width);
      bar.setPageIncrement__I(clientArea.width);
    }
    bar = canvas.getVerticalBar__();
    if (bar !== null) {
      bar.setMaximum__I(maxY);
      bar.setThumb__I(clientArea.height);
      bar.setPageIncrement__I(clientArea.height);
    }
    return;
  }
  public function scrollHorizontal__Lorg_eclipse_swt_widgets_ScrollBar_2(scrollBar: ScrollBar): void {
    var bounds: Rectangle = canvas.getClientArea__();
    var x: int = -scrollBar.getSelection__();
    if (x + maxX < bounds.width) {
      x = bounds.width - maxX;
    }
    canvas.scroll__IIIIIIZ(x, cy, cx, cy, maxX, maxY, false);
    cx = x;
    return;
  }
  public function scrollVertical__Lorg_eclipse_swt_widgets_ScrollBar_2(scrollBar: ScrollBar): void {
    var bounds: Rectangle = canvas.getClientArea__();
    var y: int = -scrollBar.getSelection__();
    if (y + maxY < bounds.height) {
      y = bounds.height - maxY;
    }
    canvas.scroll__IIIIIIZ(cx, y, cx, cy, maxX, maxY, false);
    cy = y;
    return;
  }
  public function setCaret__(): void {
    var oldCaret: Caret = canvas.getCaret__();
    if (caretButton.getSelection__()) {
      var newCaret: Caret = new Caret(canvas, 0);
      var font_1: Font = canvas.getFont__();
      newCaret.setFont__Lorg_eclipse_swt_graphics_Font_2(font_1);
      var gc: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [canvas]));
      gc.setFont__Lorg_eclipse_swt_graphics_Font_2(font_1);
      newCaret.setBounds__IIII(1, 1, 1, gc.getFontMetrics__().getHeight__());
      gc.dispose__();
      canvas.setCaret__Lorg_eclipse_swt_widgets_Caret_2(newCaret);
      canvas.setFocus__();
    } else {
      canvas.setCaret__Lorg_eclipse_swt_widgets_Caret_2(null);
    }
    if (oldCaret !== null)
      oldCaret.dispose__();
    return;
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    horizontalButton.setSelection__Z((canvas.getStyle__() & 256) != 0);
    verticalButton.setSelection__Z((canvas.getStyle__() & 512) != 0);
    borderButton.setSelection__Z((canvas.getStyle__() & 2048) != 0);
    noBackgroundButton.setSelection__Z((canvas.getStyle__() & 262144) != 0);
    noFocusButton.setSelection__Z((canvas.getStyle__() & 524288) != 0);
    noMergePaintsButton.setSelection__Z((canvas.getStyle__() & 2097152) != 0);
    noRedrawResizeButton.setSelection__Z((canvas.getStyle__() & 1048576) != 0);
    doubleBufferedButton.setSelection__Z((canvas.getStyle__() & 536870912) != 0);
    if (!instance.startup)
      this.setCaret__();
    return;
  }
}
}
