package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.widgets.Widget;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ComboTab extends Tab {
  internal var combo1: Combo;
  internal var comboGroup: Group;
  internal var dropDownButton: Button;
  internal var readOnlyButton: Button;
  internal var simpleButton: Button;
  public static var ListData: JavaArray = new JavaArray("[Ljava/lang/String;").values(ControlExample.getResourceString__Ljava_lang_String_2("ListData0_0"), ControlExample.getResourceString__Ljava_lang_String_2("ListData0_1"), ControlExample.getResourceString__Ljava_lang_String_2("ListData0_2"), ControlExample.getResourceString__Ljava_lang_String_2("ListData0_3"), ControlExample.getResourceString__Ljava_lang_String_2("ListData0_4"), ControlExample.getResourceString__Ljava_lang_String_2("ListData0_5"), ControlExample.getResourceString__Ljava_lang_String_2("ListData0_6"), ControlExample.getResourceString__Ljava_lang_String_2("ListData0_7"), ControlExample.getResourceString__Ljava_lang_String_2("ListData0_8"));
  function ComboTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    comboGroup = new Group(exampleGroup, 0);
    comboGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    comboGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    comboGroup.setText__Ljava_lang_String_2("Combo");
    return;
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (dropDownButton.getSelection__())
      style |= 4;
    if (readOnlyButton.getSelection__())
      style |= 8;
    if (simpleButton.getSelection__())
      style |= 64;
    combo1 = new Combo(comboGroup, style);
    combo1.setItems___3Ljava_lang_String_2(ListData);
    if (ListData.length >= 3) {
      combo1.setText__Ljava_lang_String_2(ListData[2]);
    }
    return;
  }
  public override function createTabFolderPage__Lorg_eclipse_swt_widgets_TabFolder_2(tabFolder: TabFolder): Composite {
    super.createTabFolderPage__Lorg_eclipse_swt_widgets_TabFolder_2(tabFolder);
    tabFolderPage.addControlListener__Lorg_eclipse_swt_events_ControlListener_2(new org.eclipse.swt.examples.controlexample.ComboTab$1(this));
    return tabFolderPage;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    dropDownButton = new Button(styleGroup, 16);
    dropDownButton.setText__Ljava_lang_String_2("SWT.DROP_DOWN");
    simpleButton = new Button(styleGroup, 16);
    simpleButton.setText__Ljava_lang_String_2("SWT.SIMPLE");
    readOnlyButton = new Button(styleGroup, 32);
    readOnlyButton.setText__Ljava_lang_String_2("SWT.READ_ONLY");
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(combo1);
  }
  public override function getMethodNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("Items", "Orientation", "Selection", "Text", "TextLimit", "ToolTipText", "VisibleItemCount");
  }
  public override function getTabText__(): String {
    return "Combo";
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    dropDownButton.setSelection__Z((combo1.getStyle__() & 4) != 0);
    simpleButton.setSelection__Z((combo1.getStyle__() & 64) != 0);
    readOnlyButton.setSelection__Z((combo1.getStyle__() & 8) != 0);
    readOnlyButton.setEnabled__Z(!simpleButton.getSelection__());
  }
}
}
