package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import java.io.*;
import java.text.*;
import java.util.*;
import java.util.ResourceBundle;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.graphics.Image;
import java.util.MissingResourceException;
import java.lang.NullPointerException;
import java.text.MessageFormat;
import java.lang.Class__;
import java.io.InputStream;
import org.eclipse.swt.graphics.ImageData;
import java.io.IOException;
import java.lang.Throwable;
import java.lang.RuntimeException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Math__;
import java.lang.Arguments;
import java.lang.Class__;
import java.lang.JavaArray;
dynamic public class ControlExample {
  public static var resourceBundle: ResourceBundle = ResourceBundle.getBundle__Ljava_lang_String_2("examples_control");
  private var shellTab: ShellTab;
  private var tabFolder: TabFolder;
  private var tabs: JavaArray;
  internal var images: JavaArray;
  public static const ciClosedFolder: int = 0;
  public static const ciOpenFolder: int = 1;
  public static const ciTarget: int = 2;
  public static const ciBackground: int = 3;
  public static const ciParentBackground: int = 4;
  public static var imageLocations: JavaArray = new JavaArray("[Ljava/lang/String;").values("closedFolder.gif", "openFolder.gif", "target.gif", "backgroundImage.png", "parentBackgroundImage.png");
  public static var imageTypes: JavaArray = new JavaArray("[I").values(1, 1, 1, 0, 0);
  internal var startup: Boolean = true;
  public function ControlExample(parent: Composite) {
    this.initResources__();
    tabFolder = new TabFolder(parent, 0);
    tabs = this.createTabs__();
    for (var i: int = 0; i < tabs.length; i++) {
      var item: TabItem = new TabItem(new Arguments(org.eclipse.swt.widgets.TabItem.TabItem__Lorg_eclipse_swt_widgets_TabFolder_2I, [tabFolder, 0]));
      item.setText__Ljava_lang_String_2(tabs[i].getTabText__());
      item.setControl__Lorg_eclipse_swt_widgets_Control_2(tabs[i].createTabFolderPage__Lorg_eclipse_swt_widgets_TabFolder_2(tabFolder));
      item.setData__Ljava_lang_Object_2(tabs[i]);
    }
    startup = false;
    return;
  }
  public function createTabs__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/examples/controlexample/Tab;").values(new ButtonTab(this), new CanvasTab(this), new ComboTab(this), new CoolBarTab(this), new DateTimeTab(this), new DialogTab(this), new ExpandBarTab(this), new GroupTab(this), new LabelTab(this), new LinkTab(this), new ListTab(this), new MenuTab(this), new ProgressBarTab(this), new SashTab(this), new ScaleTab(this), shellTab = new ShellTab(this), new SliderTab(this), new SpinnerTab(this), new TabFolderTab(this), new TableTab(this), new TextTab(this), new ToolBarTab(this), new ToolTipTab(this), new TreeTab(this), new BrowserTab(this));
  }
  public function dispose__(): void {
    if (shellTab !== null)
      shellTab.closeAllShells__();
    shellTab = null;
    tabFolder = null;
    this.freeResources__();
  }
  public function freeResources__(): void {
    if (images !== null) {
      for (var i: int = 0; i < images.length; ++i) {
        var image: Image = images[i];
        if (image !== null)
          image.dispose__();
      }
      images = null;
    }
    return;
  }
  public static function getResourceString__Ljava_lang_String_2(key: String): String {
    try {
      return resourceBundle.getString__Ljava_lang_String_2(key);
    } catch (e : MissingResourceException) {
      return key;
    } catch (e_1 : NullPointerException) {
      return "!" + key + "!";
    }
    return null;
  }
  public static function getResourceString__Ljava_lang_String_2_3Ljava_lang_Object_2(key: String, args: JavaArray): String {
    try {
      return MessageFormat.format__Ljava_lang_String_2_3Ljava_lang_Object_2(getResourceString__Ljava_lang_String_2(key), args);
    } catch (e : MissingResourceException) {
      return key;
    } catch (e_1 : NullPointerException) {
      return "!" + key + "!";
    }
    return null;
  }
  public function initResources__(): void {
    var clazz: Class__ = Class__.forName__Ljava_lang_String_2("org.eclipse.swt.examples.controlexample.ControlExample");
    if (resourceBundle !== null) {
      try {
        if (images === null) {
          images = new JavaArray("[Lorg/eclipse/swt/graphics/Image;").lengths(imageLocations.length);
          for (var i: int = 0; i < imageLocations.length; ++i) {
            var sourceStream: InputStream = clazz.getResourceAsStream__Ljava_lang_String_2(imageLocations[i]);
            var source: ImageData = new ImageData(new Arguments(org.eclipse.swt.graphics.ImageData.ImageData__Ljava_io_InputStream_2, [sourceStream]));
            if (imageTypes[i] == 1) {
              var mask: ImageData = source.getTransparencyMask__();
              images[i] = new Image(new Arguments(org.eclipse.swt.graphics.Image.Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2Lorg_eclipse_swt_graphics_ImageData_2, [null, source, mask]));
            } else {
              images[i] = new Image(new Arguments(org.eclipse.swt.graphics.Image.Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2, [null, source]));
            }
            try {
              sourceStream.close__();
            } catch (e : IOException) {
              e.printStackTrace__();
            }
          }
        }
        return;
      } catch (t : Throwable) {
      }
    }
    var error: String = (resourceBundle !== null) ? ControlExample.getResourceString__Ljava_lang_String_2("error.CouldNotLoadResources") : "Unable to load resources";
    this.freeResources__();
    throw new RuntimeException(new Arguments(java.lang.RuntimeException.RuntimeException__Ljava_lang_String_2, [error]));
    return;
  }
  public static function main___3Ljava_lang_String_2(args: JavaArray): void {
    var display: Display = new Display(new Arguments(org.eclipse.swt.widgets.Display.Display__, []));
    var shell: Shell = new Shell(new Arguments(org.eclipse.swt.widgets.Shell.Shell__Lorg_eclipse_swt_widgets_Display_2I, [display, 1264]));
    shell.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new FillLayout(new Arguments(org.eclipse.swt.layout.FillLayout.FillLayout__, [])));
    var instance: ControlExample = new ControlExample(shell);
    shell.setText__Ljava_lang_String_2(getResourceString__Ljava_lang_String_2("window.title"));
    setShellSize__Lorg_eclipse_swt_examples_controlexample_ControlExample_2Lorg_eclipse_swt_widgets_Shell_2(instance, shell);
    shell.open__();
    while (!shell.isDisposed__()) {
      if (!display.readAndDispatch__())
        display.sleep__();
    }
    instance.dispose__();
    display.dispose__();
    return;
  }
  public function setFocus__(): void {
    tabFolder.setFocus__();
    return;
  }
  public static function setShellSize__Lorg_eclipse_swt_examples_controlexample_ControlExample_2Lorg_eclipse_swt_widgets_Shell_2(instance: ControlExample, shell: Shell): void {
    var size: Point = shell.computeSize__II(-1, -1);
    var monitorArea: Rectangle = shell.getMonitor__().getClientArea__();
    if (size.x > monitorArea.width && Object(SWT.getPlatform__()).equals__Ljava_lang_Object_2("carbon")) {
      var tabItems: JavaArray = instance.tabFolder.getItems__();
      for (var i: int = 0; i < tabItems.length; i++) {
        tabItems[i].setText__Ljava_lang_String_2(instance.tabs[i].getShortTabText__());
      }
      size = shell.computeSize__II(-1, -1);
    }
    shell.setSize__II(Math__.min__II(size.x, monitorArea.width), Math__.min__II(size.y, monitorArea.height));
    return;
  }
}
}
