package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class CoolBarTab extends Tab {
  internal var coolBar: CoolBar;
  internal var pushItem: CoolItem;
  internal var dropDownItem: CoolItem;
  internal var radioItem: CoolItem;
  internal var checkItem: CoolItem;
  internal var textItem: CoolItem;
  internal var coolBarGroup: Group;
  internal var horizontalButton: Button;
  internal var verticalButton: Button;
  internal var dropDownButton: Button;
  internal var flatButton: Button;
  internal var lockedButton: Button;
  internal var sizes: JavaArray;
  internal var wrapIndices: JavaArray;
  internal var order: JavaArray;
  function CoolBarTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createOtherGroup__(): void {
    super.createOtherGroup__();
    lockedButton = new Button(otherGroup, 32);
    lockedButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Locked"));
    lockedButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.CoolBarTab$1(this));
    return;
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    coolBarGroup = new Group(exampleGroup, 0);
    coolBarGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    coolBarGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    coolBarGroup.setText__Ljava_lang_String_2("CoolBar");
    return;
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    var itemStyle: int = 0;
    var toolBarStyle: int = 8388608;
    var vertical: Boolean = false;
    if (horizontalButton.getSelection__()) {
      style |= 256;
      toolBarStyle |= 256;
    }
    if (verticalButton.getSelection__()) {
      style |= 512;
      toolBarStyle |= 512;
      vertical = true;
    }
    if (borderButton.getSelection__())
      style |= 2048;
    if (flatButton.getSelection__())
      style |= 8388608;
    if (dropDownButton.getSelection__())
      itemStyle |= 4;
    coolBar = new CoolBar(coolBarGroup, style);
    var toolBar: ToolBar = new ToolBar(coolBar, toolBarStyle);
    var item: ToolItem = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [toolBar, 8]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
    item.setToolTipText__Ljava_lang_String_2("SWT.PUSH");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [toolBar, 8]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[1]);
    item.setToolTipText__Ljava_lang_String_2("SWT.PUSH");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [toolBar, 8]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[2]);
    item.setToolTipText__Ljava_lang_String_2("SWT.PUSH");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [toolBar, 2]));
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [toolBar, 8]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
    item.setToolTipText__Ljava_lang_String_2("SWT.PUSH");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [toolBar, 8]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[1]);
    item.setToolTipText__Ljava_lang_String_2("SWT.PUSH");
    pushItem = new CoolItem(new Arguments(org.eclipse.swt.widgets.CoolItem.CoolItem__Lorg_eclipse_swt_widgets_CoolBar_2I, [coolBar, itemStyle]));
    pushItem.setControl__Lorg_eclipse_swt_widgets_Control_2(toolBar);
    pushItem.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new CoolBarTab$CoolItemSelectionListener(this));
    toolBar = new ToolBar(coolBar, toolBarStyle);
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [toolBar, 4]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[1]);
    item.setToolTipText__Ljava_lang_String_2("SWT.DROP_DOWN");
    item.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new CoolBarTab$DropDownSelectionListener(this));
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [toolBar, 4]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
    item.setToolTipText__Ljava_lang_String_2("SWT.DROP_DOWN");
    item.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new CoolBarTab$DropDownSelectionListener(this));
    dropDownItem = new CoolItem(new Arguments(org.eclipse.swt.widgets.CoolItem.CoolItem__Lorg_eclipse_swt_widgets_CoolBar_2I, [coolBar, itemStyle]));
    dropDownItem.setControl__Lorg_eclipse_swt_widgets_Control_2(toolBar);
    dropDownItem.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new CoolBarTab$CoolItemSelectionListener(this));
    toolBar = new ToolBar(coolBar, toolBarStyle);
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [toolBar, 16]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
    item.setToolTipText__Ljava_lang_String_2("SWT.RADIO");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [toolBar, 16]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
    item.setToolTipText__Ljava_lang_String_2("SWT.RADIO");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [toolBar, 16]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
    item.setToolTipText__Ljava_lang_String_2("SWT.RADIO");
    radioItem = new CoolItem(new Arguments(org.eclipse.swt.widgets.CoolItem.CoolItem__Lorg_eclipse_swt_widgets_CoolBar_2I, [coolBar, itemStyle]));
    radioItem.setControl__Lorg_eclipse_swt_widgets_Control_2(toolBar);
    radioItem.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new CoolBarTab$CoolItemSelectionListener(this));
    toolBar = new ToolBar(coolBar, toolBarStyle);
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [toolBar, 32]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
    item.setToolTipText__Ljava_lang_String_2("SWT.CHECK");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [toolBar, 32]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[2]);
    item.setToolTipText__Ljava_lang_String_2("SWT.CHECK");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [toolBar, 32]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[1]);
    item.setToolTipText__Ljava_lang_String_2("SWT.CHECK");
    item = new ToolItem(new Arguments(org.eclipse.swt.widgets.ToolItem.ToolItem__Lorg_eclipse_swt_widgets_ToolBar_2I, [toolBar, 32]));
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[2]);
    item.setToolTipText__Ljava_lang_String_2("SWT.CHECK");
    checkItem = new CoolItem(new Arguments(org.eclipse.swt.widgets.CoolItem.CoolItem__Lorg_eclipse_swt_widgets_CoolBar_2I, [coolBar, itemStyle]));
    checkItem.setControl__Lorg_eclipse_swt_widgets_Control_2(toolBar);
    checkItem.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new CoolBarTab$CoolItemSelectionListener(this));
    if (!vertical) {
      var text: Text = new Text(coolBar, 2048 | 4);
      textItem = new CoolItem(new Arguments(org.eclipse.swt.widgets.CoolItem.CoolItem__Lorg_eclipse_swt_widgets_CoolBar_2I, [coolBar, itemStyle]));
      textItem.setControl__Lorg_eclipse_swt_widgets_Control_2(text);
      textItem.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new CoolBarTab$CoolItemSelectionListener(this));
      var textSize: Point = text.computeSize__II(-1, -1);
      textSize = textItem.computeSize__II(textSize.x, textSize.y);
      textItem.setMinimumSize__Lorg_eclipse_swt_graphics_Point_2(textSize);
      textItem.setPreferredSize__Lorg_eclipse_swt_graphics_Point_2(textSize);
      textItem.setSize__Lorg_eclipse_swt_graphics_Point_2(textSize);
    }
    var coolItems: JavaArray = coolBar.getItems__();
    for (var i: int = 0; i < coolItems.length; i++) {
      var coolItem: CoolItem = coolItems[i];
      var control: Control = coolItem.getControl__();
      var size: Point = control.computeSize__II(-1, -1);
      var coolSize: Point = coolItem.computeSize__II(size.x, size.y);
      if (control is ToolBar) {
        var bar: ToolBar = ToolBar(control);
        if (bar.getItemCount__() > 0) {
          if (vertical) {
            size.y = bar.getItem__I(0).getBounds__().height;
          } else {
            size.x = bar.getItem__I(0).getWidth__();
          }
        }
      }
      coolItem.setMinimumSize__Lorg_eclipse_swt_graphics_Point_2(size);
      coolItem.setPreferredSize__Lorg_eclipse_swt_graphics_Point_2(coolSize);
      coolItem.setSize__Lorg_eclipse_swt_graphics_Point_2(coolSize);
    }
    if (order !== null && order.length == coolBar.getItemCount__()) {
      coolBar.setItemLayout___3I_3I_3Lorg_eclipse_swt_graphics_Point_2(order, wrapIndices, sizes);
    } else {
      coolBar.setWrapIndices___3I(new JavaArray("[I").values(1, 3));
    }
    coolBar.addListener__ILorg_eclipse_swt_widgets_Listener_2(11, new org.eclipse.swt.examples.controlexample.CoolBarTab$2(this));
    return;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    horizontalButton = new Button(styleGroup, 16);
    horizontalButton.setText__Ljava_lang_String_2("SWT.HORIZONTAL");
    verticalButton = new Button(styleGroup, 16);
    verticalButton.setText__Ljava_lang_String_2("SWT.VERTICAL");
    borderButton = new Button(styleGroup, 32);
    borderButton.setText__Ljava_lang_String_2("SWT.BORDER");
    flatButton = new Button(styleGroup, 32);
    flatButton.setText__Ljava_lang_String_2("SWT.FLAT");
    var itemGroup: Group = new Group(styleGroup, 0);
    itemGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    itemGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [256 | 16])));
    itemGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Item_Styles"));
    dropDownButton = new Button(itemGroup, 32);
    dropDownButton.setText__Ljava_lang_String_2("SWT.DROP_DOWN");
    return;
  }
  public override function disposeExampleWidgets__(): void {
    if (coolBar !== null) {
      sizes = coolBar.getItemSizes__();
      wrapIndices = coolBar.getWrapIndices__();
      order = coolBar.getItemOrder__();
    }
    super.disposeExampleWidgets__();
    return;
  }
  public override function getExampleWidgetItems__(): JavaArray {
    return coolBar.getItems__();
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(coolBar);
  }
  public override function getMethodNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("ToolTipText");
  }
  public override function getShortTabText__(): String {
    return "CB";
  }
  public override function getTabText__(): String {
    return "CoolBar";
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    horizontalButton.setSelection__Z((coolBar.getStyle__() & 256) != 0);
    verticalButton.setSelection__Z((coolBar.getStyle__() & 512) != 0);
    borderButton.setSelection__Z((coolBar.getStyle__() & 2048) != 0);
    flatButton.setSelection__Z((coolBar.getStyle__() & 8388608) != 0);
    dropDownButton.setSelection__Z((coolBar.getItem__I(0).getStyle__() & 4) != 0);
    lockedButton.setSelection__Z(coolBar.getLocked__());
    if (!instance.startup)
      this.setWidgetLocked__();
  }
  public function setWidgetLocked__(): void {
    coolBar.setLocked__Z(lockedButton.getSelection__());
  }
}
}
