package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Widget;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class DateTimeTab extends Tab {
  internal var dateTime1: DateTime;
  internal var dateTimeGroup: Group;
  internal var dateButton: Button;
  internal var timeButton: Button;
  internal var calendarButton: Button;
  internal var shortButton: Button;
  internal var mediumButton: Button;
  internal var longButton: Button;
  function DateTimeTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    dateTimeGroup = new Group(exampleGroup, 0);
    dateTimeGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    dateTimeGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    dateTimeGroup.setText__Ljava_lang_String_2("DateTime");
    return;
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (dateButton.getSelection__())
      style |= 32;
    if (timeButton.getSelection__())
      style |= 128;
    if (calendarButton.getSelection__())
      style |= 1024;
    if (shortButton.getSelection__())
      style |= 32768;
    if (mediumButton.getSelection__())
      style |= 65536;
    if (longButton.getSelection__())
      style |= 268435456;
    if (borderButton.getSelection__())
      style |= 2048;
    dateTime1 = new DateTime(dateTimeGroup, style);
    return;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    dateButton = new Button(styleGroup, 16);
    dateButton.setText__Ljava_lang_String_2("SWT.DATE");
    timeButton = new Button(styleGroup, 16);
    timeButton.setText__Ljava_lang_String_2("SWT.TIME");
    calendarButton = new Button(styleGroup, 16);
    calendarButton.setText__Ljava_lang_String_2("SWT.CALENDAR");
    var formatGroup: Group = new Group(styleGroup, 0);
    formatGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    shortButton = new Button(formatGroup, 16);
    shortButton.setText__Ljava_lang_String_2("SWT.SHORT");
    mediumButton = new Button(formatGroup, 16);
    mediumButton.setText__Ljava_lang_String_2("SWT.MEDIUM");
    longButton = new Button(formatGroup, 16);
    longButton.setText__Ljava_lang_String_2("SWT.LONG");
    borderButton = new Button(styleGroup, 32);
    borderButton.setText__Ljava_lang_String_2("SWT.BORDER");
    return;
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(dateTime1);
  }
  public override function getMethodNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("Day", "Hours", "Minutes", "Month", "Seconds", "Year");
  }
  public override function getTabText__(): String {
    return "DateTime";
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    dateButton.setSelection__Z((dateTime1.getStyle__() & 32) != 0);
    timeButton.setSelection__Z((dateTime1.getStyle__() & 128) != 0);
    calendarButton.setSelection__Z((dateTime1.getStyle__() & 1024) != 0);
    shortButton.setSelection__Z((dateTime1.getStyle__() & 32768) != 0);
    mediumButton.setSelection__Z((dateTime1.getStyle__() & 65536) != 0);
    longButton.setSelection__Z((dateTime1.getStyle__() & 268435456) != 0);
    borderButton.setSelection__Z((dateTime1.getStyle__() & 2048) != 0);
  }
}
}
