package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.printing.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Widget;
import java.lang.Arguments;
import java.lang.JavaArray;
import java.lang.System;
dynamic public class DialogTab extends Tab {
  internal var dialogStyleGroup: Group;
  internal var resultGroup: Group;
  internal var textWidget: Text;
  internal var dialogCombo: Combo;
  internal var createButton: Button;
  internal var okButton: Button;
  internal var cancelButton: Button;
  internal var yesButton: Button;
  internal var noButton: Button;
  internal var retryButton: Button;
  internal var abortButton: Button;
  internal var ignoreButton: Button;
  internal var iconErrorButton: Button;
  internal var iconInformationButton: Button;
  internal var iconQuestionButton: Button;
  internal var iconWarningButton: Button;
  internal var iconWorkingButton: Button;
  internal var noIconButton: Button;
  internal var primaryModalButton: Button;
  internal var applicationModalButton: Button;
  internal var systemModalButton: Button;
  internal var saveButton: Button;
  internal var openButton: Button;
  internal var multiButton: Button;
  public static var FilterExtensions: JavaArray = new JavaArray("[Ljava/lang/String;").values("*.txt", "*.bat", "*.doc", "*");
  public static var FilterNames: JavaArray = new JavaArray("[Ljava/lang/String;").values(ControlExample.getResourceString__Ljava_lang_String_2("FilterName_0"), ControlExample.getResourceString__Ljava_lang_String_2("FilterName_1"), ControlExample.getResourceString__Ljava_lang_String_2("FilterName_2"), ControlExample.getResourceString__Ljava_lang_String_2("FilterName_3"));
  function DialogTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public function buttonStyleSelected__Lorg_eclipse_swt_events_SelectionEvent_2(event: SelectionEvent): void {
    var ok: Boolean = okButton.getSelection__();
    var cancel: Boolean = cancelButton.getSelection__();
    var yes: Boolean = yesButton.getSelection__();
    var no: Boolean = noButton.getSelection__();
    var abort: Boolean = abortButton.getSelection__();
    var retry: Boolean = retryButton.getSelection__();
    var ignore_1: Boolean = ignoreButton.getSelection__();
    okButton.setEnabled__Z(!(yes || no || retry || abort || ignore_1));
    cancelButton.setEnabled__Z(!(abort || ignore_1 || (yes != no)));
    yesButton.setEnabled__Z(!(ok || retry || abort || ignore_1 || (cancel && !yes && !no)));
    noButton.setEnabled__Z(!(ok || retry || abort || ignore_1 || (cancel && !yes && !no)));
    retryButton.setEnabled__Z(!(ok || yes || no));
    abortButton.setEnabled__Z(!(ok || cancel || yes || no));
    ignoreButton.setEnabled__Z(!(ok || cancel || yes || no));
    createButton.setEnabled__Z(!(ok || cancel || yes || no || retry || abort || ignore_1) || ok || (ok && cancel) || (yes && no) || (yes && no && cancel) || (retry && cancel) || (abort && retry && ignore_1));
    return;
  }
  public function createButtonSelected__Lorg_eclipse_swt_events_SelectionEvent_2(event: SelectionEvent): void {
    var style: int = this.getDefaultStyle__();
    if (okButton.getEnabled__() && okButton.getSelection__())
      style |= 32;
    if (cancelButton.getEnabled__() && cancelButton.getSelection__())
      style |= 256;
    if (yesButton.getEnabled__() && yesButton.getSelection__())
      style |= 64;
    if (noButton.getEnabled__() && noButton.getSelection__())
      style |= 128;
    if (retryButton.getEnabled__() && retryButton.getSelection__())
      style |= 1024;
    if (abortButton.getEnabled__() && abortButton.getSelection__())
      style |= 512;
    if (ignoreButton.getEnabled__() && ignoreButton.getSelection__())
      style |= 2048;
    if (iconErrorButton.getEnabled__() && iconErrorButton.getSelection__())
      style |= 1;
    if (iconInformationButton.getEnabled__() && iconInformationButton.getSelection__())
      style |= 2;
    if (iconQuestionButton.getEnabled__() && iconQuestionButton.getSelection__())
      style |= 4;
    if (iconWarningButton.getEnabled__() && iconWarningButton.getSelection__())
      style |= 8;
    if (iconWorkingButton.getEnabled__() && iconWorkingButton.getSelection__())
      style |= 16;
    if (primaryModalButton.getEnabled__() && primaryModalButton.getSelection__())
      style |= 32768;
    if (applicationModalButton.getEnabled__() && applicationModalButton.getSelection__())
      style |= 65536;
    if (systemModalButton.getEnabled__() && systemModalButton.getSelection__())
      style |= 131072;
    if (saveButton.getEnabled__() && saveButton.getSelection__())
      style |= 8192;
    if (openButton.getEnabled__() && openButton.getSelection__())
      style |= 4096;
    if (multiButton.getEnabled__() && multiButton.getSelection__())
      style |= 2;
    var name: String = dialogCombo.getText__();
    if (Object(name).equals__Ljava_lang_Object_2(ControlExample.getResourceString__Ljava_lang_String_2("ColorDialog"))) {
      var dialog: ColorDialog = new ColorDialog(new Arguments(org.eclipse.swt.widgets.ColorDialog.ColorDialog__Lorg_eclipse_swt_widgets_Shell_2I, [shell, style]));
      dialog.setRGB__Lorg_eclipse_swt_graphics_RGB_2(new RGB(new Arguments(org.eclipse.swt.graphics.RGB.RGB__III, [100, 100, 100])));
      dialog.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Title"));
      var result: RGB = dialog.open__();
      textWidget.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("ColorDialog") + "\n");
      textWidget.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2_3Ljava_lang_Object_2("Result", new JavaArray("[Ljava/lang/String;").values("" + java.lang.System.stringValueOf(result))) + "\n");
      textWidget.append__Ljava_lang_String_2("getRGB() = " + java.lang.System.stringValueOf(dialog.getRGB__()) + "\n" + "\n");
      return;
    }
    if (Object(name).equals__Ljava_lang_Object_2(ControlExample.getResourceString__Ljava_lang_String_2("DirectoryDialog"))) {
      var dialog_1: DirectoryDialog = new DirectoryDialog(new Arguments(org.eclipse.swt.widgets.DirectoryDialog.DirectoryDialog__Lorg_eclipse_swt_widgets_Shell_2I, [shell, style]));
      dialog_1.setMessage__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Example_string"));
      dialog_1.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Title"));
      var result_1: String = dialog_1.open__();
      textWidget.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("DirectoryDialog") + "\n");
      textWidget.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2_3Ljava_lang_Object_2("Result", new JavaArray("[Ljava/lang/String;").values("" + result_1)) + "\n" + "\n");
      return;
    }
    if (Object(name).equals__Ljava_lang_Object_2(ControlExample.getResourceString__Ljava_lang_String_2("FileDialog"))) {
      var dialog_2: FileDialog = new FileDialog(new Arguments(org.eclipse.swt.widgets.FileDialog.FileDialog__Lorg_eclipse_swt_widgets_Shell_2I, [shell, style]));
      dialog_2.setFileName__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("readme_txt"));
      dialog_2.setFilterNames___3Ljava_lang_String_2(FilterNames);
      dialog_2.setFilterExtensions___3Ljava_lang_String_2(FilterExtensions);
      dialog_2.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Title"));
      var result_2: String = dialog_2.open__();
      textWidget.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("FileDialog") + "\n");
      textWidget.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2_3Ljava_lang_Object_2("Result", new JavaArray("[Ljava/lang/String;").values("" + result_2)) + "\n");
      textWidget.append__Ljava_lang_String_2("getFileNames() =" + "\n");
      if ((dialog_2.getStyle__() & 2) != 0) {
        var files: JavaArray = dialog_2.getFileNames__();
        for (var i: int = 0; i < files.length; i++) {
          textWidget.append__Ljava_lang_String_2("\t" + files[i] + "\n");
        }
      }
      textWidget.append__Ljava_lang_String_2("getFilterIndex() = " + dialog_2.getFilterIndex__() + "\n" + "\n");
      return;
    }
    if (Object(name).equals__Ljava_lang_Object_2(ControlExample.getResourceString__Ljava_lang_String_2("FontDialog"))) {
      var dialog_3: FontDialog = new FontDialog(new Arguments(org.eclipse.swt.widgets.FontDialog.FontDialog__Lorg_eclipse_swt_widgets_Shell_2I, [shell, style]));
      dialog_3.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Title"));
      var result_3: FontData = dialog_3.open__();
      textWidget.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("FontDialog") + "\n");
      textWidget.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2_3Ljava_lang_Object_2("Result", new JavaArray("[Ljava/lang/String;").values("" + java.lang.System.stringValueOf(result_3))) + "\n");
      textWidget.append__Ljava_lang_String_2("getFontList() =" + "\n");
      var fonts: JavaArray = dialog_3.getFontList__();
      if (fonts !== null) {
        for (var i_1: int = 0; i_1 < fonts.length; i_1++) {
          textWidget.append__Ljava_lang_String_2("\t" + java.lang.System.stringValueOf(fonts[i_1]) + "\n");
        }
      }
      textWidget.append__Ljava_lang_String_2("getRGB() = " + java.lang.System.stringValueOf(dialog_3.getRGB__()) + "\n" + "\n");
      return;
    }
    if (Object(name).equals__Ljava_lang_Object_2(ControlExample.getResourceString__Ljava_lang_String_2("PrintDialog"))) {
      var dialog_4: PrintDialog = new PrintDialog(new Arguments(org.eclipse.swt.printing.PrintDialog.PrintDialog__Lorg_eclipse_swt_widgets_Shell_2I, [shell, style]));
      dialog_4.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Title"));
      var result_4: PrinterData = dialog_4.open__();
      textWidget.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("PrintDialog") + "\n");
      textWidget.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2_3Ljava_lang_Object_2("Result", new JavaArray("[Ljava/lang/String;").values("" + java.lang.System.stringValueOf(result_4))) + "\n");
      textWidget.append__Ljava_lang_String_2("getScope() = " + dialog_4.getScope__() + "\n");
      textWidget.append__Ljava_lang_String_2("getStartPage() = " + dialog_4.getStartPage__() + "\n");
      textWidget.append__Ljava_lang_String_2("getEndPage() = " + dialog_4.getEndPage__() + "\n");
      textWidget.append__Ljava_lang_String_2("getPrintToFile() = " + dialog_4.getPrintToFile__() + "\n" + "\n");
      return;
    }
    if (Object(name).equals__Ljava_lang_Object_2(ControlExample.getResourceString__Ljava_lang_String_2("MessageBox"))) {
      var dialog_5: MessageBox = new MessageBox(new Arguments(org.eclipse.swt.widgets.MessageBox.MessageBox__Lorg_eclipse_swt_widgets_Shell_2I, [shell, style]));
      dialog_5.setMessage__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Example_string"));
      dialog_5.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Title"));
      var result_5: int = dialog_5.open__();
      textWidget.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("MessageBox") + "\n");
      switch (result_5) {
        case 32 :
          textWidget.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2_3Ljava_lang_Object_2("Result", new JavaArray("[Ljava/lang/String;").values("SWT.OK")));
          break;
        case 64 :
          textWidget.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2_3Ljava_lang_Object_2("Result", new JavaArray("[Ljava/lang/String;").values("SWT.YES")));
          break;
        case 128 :
          textWidget.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2_3Ljava_lang_Object_2("Result", new JavaArray("[Ljava/lang/String;").values("SWT.NO")));
          break;
        case 256 :
          textWidget.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2_3Ljava_lang_Object_2("Result", new JavaArray("[Ljava/lang/String;").values("SWT.CANCEL")));
          break;
        case 512 :
          textWidget.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2_3Ljava_lang_Object_2("Result", new JavaArray("[Ljava/lang/String;").values("SWT.ABORT")));
          break;
        case 1024 :
          textWidget.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2_3Ljava_lang_Object_2("Result", new JavaArray("[Ljava/lang/String;").values("SWT.RETRY")));
          break;
        case 2048 :
          textWidget.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2_3Ljava_lang_Object_2("Result", new JavaArray("[Ljava/lang/String;").values("SWT.IGNORE")));
          break;
        default :
          textWidget.append__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2_3Ljava_lang_Object_2("Result", new JavaArray("[Ljava/lang/String;").values("" + result_5)));
          break;
      }
      textWidget.append__Ljava_lang_String_2("\n" + "\n");
    }
    return;
  }
  public override function createControlGroup__(): void {
    controlGroup = new Group(tabFolderPage, 0);
    var gridLayout: GridLayout = new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, []));
    controlGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(gridLayout);
    gridLayout.numColumns = 2;
    gridLayout.makeColumnsEqualWidth = true;
    controlGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [256 | 16])));
    controlGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Parameters"));
    dialogStyleGroup = new Group(controlGroup, 0);
    dialogStyleGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    var gridData: GridData = new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [64]));
    gridData.horizontalSpan = 2;
    dialogStyleGroup.setLayoutData__Ljava_lang_Object_2(gridData);
    dialogStyleGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Dialog_Type"));
    return;
  }
  public override function createControlWidgets__(): void {
    var strings: JavaArray = new JavaArray("[Ljava/lang/String;").values(ControlExample.getResourceString__Ljava_lang_String_2("ColorDialog"), ControlExample.getResourceString__Ljava_lang_String_2("DirectoryDialog"), ControlExample.getResourceString__Ljava_lang_String_2("FileDialog"), ControlExample.getResourceString__Ljava_lang_String_2("FontDialog"), ControlExample.getResourceString__Ljava_lang_String_2("PrintDialog"), ControlExample.getResourceString__Ljava_lang_String_2("MessageBox"));
    dialogCombo = new Combo(dialogStyleGroup, 8);
    dialogCombo.setItems___3Ljava_lang_String_2(strings);
    dialogCombo.setText__Ljava_lang_String_2(strings[0]);
    dialogCombo.setVisibleItemCount__I(strings.length);
    createButton = new Button(dialogStyleGroup, 0);
    createButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Create_Dialog"));
    createButton.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [64])));
    var buttonStyleGroup: Group = new Group(controlGroup, 0);
    buttonStyleGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    buttonStyleGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [256 | 16])));
    buttonStyleGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Button_Styles"));
    okButton = new Button(buttonStyleGroup, 32);
    okButton.setText__Ljava_lang_String_2("SWT.OK");
    cancelButton = new Button(buttonStyleGroup, 32);
    cancelButton.setText__Ljava_lang_String_2("SWT.CANCEL");
    yesButton = new Button(buttonStyleGroup, 32);
    yesButton.setText__Ljava_lang_String_2("SWT.YES");
    noButton = new Button(buttonStyleGroup, 32);
    noButton.setText__Ljava_lang_String_2("SWT.NO");
    retryButton = new Button(buttonStyleGroup, 32);
    retryButton.setText__Ljava_lang_String_2("SWT.RETRY");
    abortButton = new Button(buttonStyleGroup, 32);
    abortButton.setText__Ljava_lang_String_2("SWT.ABORT");
    ignoreButton = new Button(buttonStyleGroup, 32);
    ignoreButton.setText__Ljava_lang_String_2("SWT.IGNORE");
    var iconStyleGroup: Group = new Group(controlGroup, 0);
    iconStyleGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    iconStyleGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [256 | 16])));
    iconStyleGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Icon_Styles"));
    iconErrorButton = new Button(iconStyleGroup, 16);
    iconErrorButton.setText__Ljava_lang_String_2("SWT.ICON_ERROR");
    iconInformationButton = new Button(iconStyleGroup, 16);
    iconInformationButton.setText__Ljava_lang_String_2("SWT.ICON_INFORMATION");
    iconQuestionButton = new Button(iconStyleGroup, 16);
    iconQuestionButton.setText__Ljava_lang_String_2("SWT.ICON_QUESTION");
    iconWarningButton = new Button(iconStyleGroup, 16);
    iconWarningButton.setText__Ljava_lang_String_2("SWT.ICON_WARNING");
    iconWorkingButton = new Button(iconStyleGroup, 16);
    iconWorkingButton.setText__Ljava_lang_String_2("SWT.ICON_WORKING");
    noIconButton = new Button(iconStyleGroup, 16);
    noIconButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("No_Icon"));
    var modalStyleGroup: Group = new Group(controlGroup, 0);
    modalStyleGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    modalStyleGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [256 | 16])));
    modalStyleGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Modal_Styles"));
    primaryModalButton = new Button(modalStyleGroup, 16);
    primaryModalButton.setText__Ljava_lang_String_2("SWT.PRIMARY_MODAL");
    applicationModalButton = new Button(modalStyleGroup, 16);
    applicationModalButton.setText__Ljava_lang_String_2("SWT.APPLICATION_MODAL");
    systemModalButton = new Button(modalStyleGroup, 16);
    systemModalButton.setText__Ljava_lang_String_2("SWT.SYSTEM_MODAL");
    var fileDialogStyleGroup: Group = new Group(controlGroup, 0);
    fileDialogStyleGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    fileDialogStyleGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [256 | 16])));
    fileDialogStyleGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("File_Dialog_Styles"));
    openButton = new Button(fileDialogStyleGroup, 16);
    openButton.setText__Ljava_lang_String_2("SWT.OPEN");
    saveButton = new Button(fileDialogStyleGroup, 16);
    saveButton.setText__Ljava_lang_String_2("SWT.SAVE");
    multiButton = new Button(fileDialogStyleGroup, 32);
    multiButton.setText__Ljava_lang_String_2("SWT.MULTI");
    if (Tab.RTL_SUPPORT_ENABLE) {
      this.createOrientationGroup__();
    }
    dialogCombo.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.DialogTab$1(this));
    createButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.DialogTab$2(this));
    var buttonStyleListener: SelectionListener = new org.eclipse.swt.examples.controlexample.DialogTab$3(this);
    okButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(buttonStyleListener);
    cancelButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(buttonStyleListener);
    yesButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(buttonStyleListener);
    noButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(buttonStyleListener);
    retryButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(buttonStyleListener);
    abortButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(buttonStyleListener);
    ignoreButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(buttonStyleListener);
    okButton.setEnabled__Z(false);
    cancelButton.setEnabled__Z(false);
    yesButton.setEnabled__Z(false);
    noButton.setEnabled__Z(false);
    retryButton.setEnabled__Z(false);
    abortButton.setEnabled__Z(false);
    ignoreButton.setEnabled__Z(false);
    iconErrorButton.setEnabled__Z(false);
    iconInformationButton.setEnabled__Z(false);
    iconQuestionButton.setEnabled__Z(false);
    iconWarningButton.setEnabled__Z(false);
    iconWorkingButton.setEnabled__Z(false);
    noIconButton.setEnabled__Z(false);
    saveButton.setEnabled__Z(false);
    openButton.setEnabled__Z(false);
    openButton.setSelection__Z(true);
    multiButton.setEnabled__Z(false);
    noIconButton.setSelection__Z(true);
    return;
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    exampleGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    resultGroup = new Group(exampleGroup, 0);
    resultGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    resultGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    resultGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Dialog_Result"));
    return;
  }
  public override function createExampleWidgets__(): void {
    textWidget = new Text(resultGroup, 256 | 512 | 2048);
    var gridData: GridData = new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [1808]));
    textWidget.setLayoutData__Ljava_lang_Object_2(gridData);
    return;
  }
  public override function createListenersGroup__(): void {
  }
  public function dialogSelected__Lorg_eclipse_swt_events_SelectionEvent_2(event: SelectionEvent): void {
    var name: String = dialogCombo.getText__();
    var isMessageBox: Boolean = Object(name).equals__Ljava_lang_Object_2(ControlExample.getResourceString__Ljava_lang_String_2("MessageBox"));
    var isFileDialog: Boolean = Object(name).equals__Ljava_lang_Object_2(ControlExample.getResourceString__Ljava_lang_String_2("FileDialog"));
    okButton.setEnabled__Z(isMessageBox);
    cancelButton.setEnabled__Z(isMessageBox);
    yesButton.setEnabled__Z(isMessageBox);
    noButton.setEnabled__Z(isMessageBox);
    retryButton.setEnabled__Z(isMessageBox);
    abortButton.setEnabled__Z(isMessageBox);
    ignoreButton.setEnabled__Z(isMessageBox);
    iconErrorButton.setEnabled__Z(isMessageBox);
    iconInformationButton.setEnabled__Z(isMessageBox);
    iconQuestionButton.setEnabled__Z(isMessageBox);
    iconWarningButton.setEnabled__Z(isMessageBox);
    iconWorkingButton.setEnabled__Z(isMessageBox);
    noIconButton.setEnabled__Z(isMessageBox);
    saveButton.setEnabled__Z(isFileDialog);
    openButton.setEnabled__Z(isFileDialog);
    multiButton.setEnabled__Z(isFileDialog);
    if (!isMessageBox) {
      okButton.setSelection__Z(false);
      cancelButton.setSelection__Z(false);
      yesButton.setSelection__Z(false);
      noButton.setSelection__Z(false);
      retryButton.setSelection__Z(false);
      abortButton.setSelection__Z(false);
      ignoreButton.setSelection__Z(false);
    }
    return;
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").lengths(0);
  }
  public override function getTabText__(): String {
    return "Dialog";
  }
  public override function recreateExampleWidgets__(): void {
    if (textWidget === null) {
      super.recreateExampleWidgets__();
    }
    return;
  }
}
}
