package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ExpandBarTab extends Tab {
  internal var expandBar1: ExpandBar;
  internal var expandBarGroup: Group;
  internal var verticalButton: Button;
  function ExpandBarTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    expandBarGroup = new Group(exampleGroup, 0);
    expandBarGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    expandBarGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    expandBarGroup.setText__Ljava_lang_String_2("ExpandBar");
    return;
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (borderButton.getSelection__())
      style |= 2048;
    if (verticalButton.getSelection__())
      style |= 512;
    expandBar1 = new ExpandBar(expandBarGroup, style);
    var composite: Composite = new Composite(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [expandBar1, 0]));
    composite.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    new Button(composite, 8).setText__Ljava_lang_String_2("SWT.PUSH");
    new Button(composite, 16).setText__Ljava_lang_String_2("SWT.RADIO");
    new Button(composite, 32).setText__Ljava_lang_String_2("SWT.CHECK");
    new Button(composite, 2).setText__Ljava_lang_String_2("SWT.TOGGLE");
    var item: ExpandItem = new ExpandItem(new Arguments(org.eclipse.swt.widgets.ExpandItem.ExpandItem__Lorg_eclipse_swt_widgets_ExpandBar_2II, [expandBar1, 0, 0]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Item1_Text"));
    item.setHeight__I(composite.computeSize__II(-1, -1).y);
    item.setControl__Lorg_eclipse_swt_widgets_Control_2(composite);
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
    composite = new Composite(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [expandBar1, 0]));
    composite.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__IZ, [2, false])));
    new Label(composite, 0).setImage__Lorg_eclipse_swt_graphics_Image_2(display.getSystemImage__I(1));
    new Label(composite, 0).setText__Ljava_lang_String_2("SWT.ICON_ERROR");
    new Label(composite, 0).setImage__Lorg_eclipse_swt_graphics_Image_2(display.getSystemImage__I(2));
    new Label(composite, 0).setText__Ljava_lang_String_2("SWT.ICON_INFORMATION");
    new Label(composite, 0).setImage__Lorg_eclipse_swt_graphics_Image_2(display.getSystemImage__I(8));
    new Label(composite, 0).setText__Ljava_lang_String_2("SWT.ICON_WARNING");
    new Label(composite, 0).setImage__Lorg_eclipse_swt_graphics_Image_2(display.getSystemImage__I(4));
    new Label(composite, 0).setText__Ljava_lang_String_2("SWT.ICON_QUESTION");
    item = new ExpandItem(new Arguments(org.eclipse.swt.widgets.ExpandItem.ExpandItem__Lorg_eclipse_swt_widgets_ExpandBar_2II, [expandBar1, 0, 1]));
    item.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Item2_Text"));
    item.setHeight__I(composite.computeSize__II(-1, -1).y);
    item.setControl__Lorg_eclipse_swt_widgets_Control_2(composite);
    item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[1]);
    item.setExpanded__Z(true);
    return;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    verticalButton = new Button(styleGroup, 32);
    verticalButton.setText__Ljava_lang_String_2("SWT.V_SCROLL");
    verticalButton.setSelection__Z(true);
    borderButton = new Button(styleGroup, 32);
    borderButton.setText__Ljava_lang_String_2("SWT.BORDER");
    return;
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(expandBar1);
  }
  public override function getMethodNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("Spacing");
  }
  public override function getShortTabText__(): String {
    return "EB";
  }
  public override function getTabText__(): String {
    return "ExpandBar";
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    var widgets: JavaArray = this.getExampleWidgets__();
    if (widgets.length != 0) {
      verticalButton.setSelection__Z((widgets[0].getStyle__() & 512) != 0);
      borderButton.setSelection__Z((widgets[0].getStyle__() & 2048) != 0);
    }
    return;
  }
}
}
