package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Widget;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class GroupTab extends Tab {
  internal var titleButton: Button;
  internal var group1: Group;
  internal var groupGroup: Group;
  internal var shadowEtchedInButton: Button;
  internal var shadowEtchedOutButton: Button;
  internal var shadowInButton: Button;
  internal var shadowOutButton: Button;
  internal var shadowNoneButton: Button;
  function GroupTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createOtherGroup__(): void {
    super.createOtherGroup__();
    titleButton = new Button(otherGroup, 32);
    titleButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Title_Text"));
    titleButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.GroupTab$1(this));
    return;
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    groupGroup = new Group(exampleGroup, 0);
    groupGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    groupGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    groupGroup.setText__Ljava_lang_String_2("Group");
    return;
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (shadowEtchedInButton.getSelection__())
      style |= 16;
    if (shadowEtchedOutButton.getSelection__())
      style |= 64;
    if (shadowInButton.getSelection__())
      style |= 4;
    if (shadowOutButton.getSelection__())
      style |= 8;
    if (shadowNoneButton.getSelection__())
      style |= 32;
    if (borderButton.getSelection__())
      style |= 2048;
    group1 = new Group(groupGroup, style);
    return;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    shadowEtchedInButton = new Button(styleGroup, 16);
    shadowEtchedInButton.setText__Ljava_lang_String_2("SWT.SHADOW_ETCHED_IN");
    shadowEtchedInButton.setSelection__Z(true);
    shadowEtchedOutButton = new Button(styleGroup, 16);
    shadowEtchedOutButton.setText__Ljava_lang_String_2("SWT.SHADOW_ETCHED_OUT");
    shadowInButton = new Button(styleGroup, 16);
    shadowInButton.setText__Ljava_lang_String_2("SWT.SHADOW_IN");
    shadowOutButton = new Button(styleGroup, 16);
    shadowOutButton.setText__Ljava_lang_String_2("SWT.SHADOW_OUT");
    shadowNoneButton = new Button(styleGroup, 16);
    shadowNoneButton.setText__Ljava_lang_String_2("SWT.SHADOW_NONE");
    borderButton = new Button(styleGroup, 32);
    borderButton.setText__Ljava_lang_String_2("SWT.BORDER");
    return;
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(group1);
  }
  public override function getMethodNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("Text", "ToolTipText");
  }
  public override function getTabText__(): String {
    return "Group";
  }
  public function setTitleText__(): void {
    if (titleButton.getSelection__()) {
      group1.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Title_Text"));
    } else {
      group1.setText__Ljava_lang_String_2("");
    }
    this.setExampleWidgetSize__();
    return;
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    shadowEtchedInButton.setSelection__Z((group1.getStyle__() & 16) != 0);
    shadowEtchedOutButton.setSelection__Z((group1.getStyle__() & 64) != 0);
    shadowInButton.setSelection__Z((group1.getStyle__() & 4) != 0);
    shadowOutButton.setSelection__Z((group1.getStyle__() & 8) != 0);
    shadowNoneButton.setSelection__Z((group1.getStyle__() & 32) != 0);
    borderButton.setSelection__Z((group1.getStyle__() & 2048) != 0);
    if (!instance.startup)
      this.setTitleText__();
    return;
  }
}
}
