package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Widget;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class LabelTab extends AlignableTab {
  internal var label1: Label;
  internal var label2: Label;
  internal var label3: Label;
  internal var label4: Label;
  internal var label5: Label;
  internal var label6: Label;
  internal var textLabelGroup: Group;
  internal var imageLabelGroup: Group;
  internal var wrapButton: Button;
  internal var separatorButton: Button;
  internal var horizontalButton: Button;
  internal var verticalButton: Button;
  internal var shadowInButton: Button;
  internal var shadowOutButton: Button;
  internal var shadowNoneButton: Button;
  function LabelTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    textLabelGroup = new Group(exampleGroup, 0);
    var gridLayout: GridLayout = new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, []));
    textLabelGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(gridLayout);
    gridLayout.numColumns = 3;
    textLabelGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    textLabelGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Text_Labels"));
    imageLabelGroup = new Group(exampleGroup, 32);
    gridLayout = new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, []));
    imageLabelGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(gridLayout);
    gridLayout.numColumns = 3;
    imageLabelGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    imageLabelGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Image_Labels"));
    return;
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (wrapButton.getSelection__())
      style |= 64;
    if (separatorButton.getSelection__())
      style |= 2;
    if (horizontalButton.getSelection__())
      style |= 256;
    if (verticalButton.getSelection__())
      style |= 512;
    if (shadowInButton.getSelection__())
      style |= 4;
    if (shadowOutButton.getSelection__())
      style |= 8;
    if (shadowNoneButton.getSelection__())
      style |= 32;
    if (borderButton.getSelection__())
      style |= 2048;
    if (leftButton.getSelection__())
      style |= 16384;
    if (centerButton.getSelection__())
      style |= 16777216;
    if (rightButton.getSelection__())
      style |= 131072;
    label1 = new Label(textLabelGroup, style);
    label1.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("One"));
    label2 = new Label(textLabelGroup, style);
    label2.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Two"));
    label3 = new Label(textLabelGroup, style);
    if (wrapButton.getSelection__()) {
      label3.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Wrap_Text"));
    } else {
      label3.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Three"));
    }
    label4 = new Label(imageLabelGroup, style);
    label4.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
    label5 = new Label(imageLabelGroup, style);
    label5.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[1]);
    label6 = new Label(imageLabelGroup, style);
    label6.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[2]);
    return;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    wrapButton = new Button(styleGroup, 32);
    wrapButton.setText__Ljava_lang_String_2("SWT.WRAP");
    separatorButton = new Button(styleGroup, 32);
    separatorButton.setText__Ljava_lang_String_2("SWT.SEPARATOR");
    horizontalButton = new Button(styleGroup, 16);
    horizontalButton.setText__Ljava_lang_String_2("SWT.HORIZONTAL");
    verticalButton = new Button(styleGroup, 16);
    verticalButton.setText__Ljava_lang_String_2("SWT.VERTICAL");
    var styleSubGroup: Group = new Group(styleGroup, 0);
    styleSubGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    shadowInButton = new Button(styleSubGroup, 16);
    shadowInButton.setText__Ljava_lang_String_2("SWT.SHADOW_IN");
    shadowOutButton = new Button(styleSubGroup, 16);
    shadowOutButton.setText__Ljava_lang_String_2("SWT.SHADOW_OUT");
    shadowNoneButton = new Button(styleSubGroup, 16);
    shadowNoneButton.setText__Ljava_lang_String_2("SWT.SHADOW_NONE");
    borderButton = new Button(styleGroup, 32);
    borderButton.setText__Ljava_lang_String_2("SWT.BORDER");
    return;
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(label1, label2, label3, label4, label5, label6);
  }
  public override function getMethodNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("Text", "ToolTipText");
  }
  public override function getTabText__(): String {
    return "Label";
  }
  public override function setExampleWidgetAlignment__(): void {
    var alignment: int = 0;
    if (leftButton.getSelection__())
      alignment = 16384;
    if (centerButton.getSelection__())
      alignment = 16777216;
    if (rightButton.getSelection__())
      alignment = 131072;
    label1.setAlignment__I(alignment);
    label2.setAlignment__I(alignment);
    label3.setAlignment__I(alignment);
    label4.setAlignment__I(alignment);
    label5.setAlignment__I(alignment);
    label6.setAlignment__I(alignment);
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    var isSeparator: Boolean = (label1.getStyle__() & 2) != 0;
    wrapButton.setSelection__Z(!isSeparator && (label1.getStyle__() & 64) != 0);
    leftButton.setSelection__Z(!isSeparator && (label1.getStyle__() & 16384) != 0);
    centerButton.setSelection__Z(!isSeparator && (label1.getStyle__() & 16777216) != 0);
    rightButton.setSelection__Z(!isSeparator && (label1.getStyle__() & 131072) != 0);
    shadowInButton.setSelection__Z(isSeparator && (label1.getStyle__() & 4) != 0);
    shadowOutButton.setSelection__Z(isSeparator && (label1.getStyle__() & 8) != 0);
    shadowNoneButton.setSelection__Z(isSeparator && (label1.getStyle__() & 32) != 0);
    horizontalButton.setSelection__Z(isSeparator && (label1.getStyle__() & 256) != 0);
    verticalButton.setSelection__Z(isSeparator && (label1.getStyle__() & 512) != 0);
    wrapButton.setEnabled__Z(!isSeparator);
    leftButton.setEnabled__Z(!isSeparator);
    centerButton.setEnabled__Z(!isSeparator);
    rightButton.setEnabled__Z(!isSeparator);
    shadowInButton.setEnabled__Z(isSeparator);
    shadowOutButton.setEnabled__Z(isSeparator);
    shadowNoneButton.setEnabled__Z(isSeparator);
    horizontalButton.setEnabled__Z(isSeparator);
    verticalButton.setEnabled__Z(isSeparator);
  }
}
}
