package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.events.SelectionEvent;
import java.lang.System;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.events.SelectionAdapter;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class MenuTab extends Tab {
  internal var barButton: Button;
  internal var dropDownButton: Button;
  internal var popUpButton: Button;
  internal var noRadioGroupButton: Button;
  internal var leftToRightButton: Button;
  internal var rightToLeftButton: Button;
  internal var checkButton: Button;
  internal var cascadeButton: Button;
  internal var pushButton: Button;
  internal var radioButton: Button;
  internal var separatorButton: Button;
  internal var imagesButton: Button;
  internal var acceleratorsButton: Button;
  internal var mnemonicsButton: Button;
  internal var subMenuButton: Button;
  internal var subSubMenuButton: Button;
  internal var createButton: Button;
  internal var closeAllButton: Button;
  internal var menuItemStyleGroup: Group;
  internal var shellCount: int = 0;
  internal var shells: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Shell;").lengths(4);
  function MenuTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public function closeAllShells__(): void {
    for (var i: int = 0; i < shellCount; i++) {
      if ((shells[i] !== null) ? (!shells[i].isDisposed__()) : (!shells[i].isDisposed__(), false)) {
        shells[i].dispose__();
      }
    }
    shellCount = 0;
    return;
  }
  public function createButtonSelected__Lorg_eclipse_swt_events_SelectionEvent_2(event: SelectionEvent): void {
    if (shellCount >= shells.length) {
      var newShells: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Shell;").lengths(shells.length + 4);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(shells, 0, newShells, 0, shells.length);
      shells = newShells;
    }
    var orientation: int = 0;
    if (leftToRightButton.getSelection__())
      orientation |= 33554432;
    if (rightToLeftButton.getSelection__())
      orientation |= 67108864;
    var radioBehavior: int = 0;
    if (noRadioGroupButton.getSelection__())
      radioBehavior |= 4194304;
    var shell_1: Shell = new Shell(new Arguments(org.eclipse.swt.widgets.Shell.Shell__I, [1264 | orientation]));
    shells[shellCount] = shell_1;
    if (barButton.getSelection__()) {
      var menuBar: Menu = new Menu(new Arguments(org.eclipse.swt.widgets.Menu.Menu__Lorg_eclipse_swt_widgets_Decorations_2I, [shell_1, 2 | radioBehavior]));
      shell_1.setMenuBar__Lorg_eclipse_swt_widgets_Menu_2(menuBar);
      this.hookListeners__Lorg_eclipse_swt_widgets_Widget_2(menuBar);
      if (dropDownButton.getSelection__() && cascadeButton.getSelection__()) {
        var item: MenuItem = new MenuItem(new Arguments(org.eclipse.swt.widgets.MenuItem.MenuItem__Lorg_eclipse_swt_widgets_Menu_2I, [menuBar, 64]));
        item.setText__Ljava_lang_String_2(this.getMenuItemText__Ljava_lang_String_2("Cascade"));
        if (imagesButton.getSelection__())
          item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[1]);
        this.hookListeners__Lorg_eclipse_swt_widgets_Widget_2(item);
        var dropDownMenu: Menu = new Menu(new Arguments(org.eclipse.swt.widgets.Menu.Menu__Lorg_eclipse_swt_widgets_Decorations_2I, [shell_1, 4 | radioBehavior]));
        item.setMenu__Lorg_eclipse_swt_widgets_Menu_2(dropDownMenu);
        this.hookListeners__Lorg_eclipse_swt_widgets_Widget_2(dropDownMenu);
        this.createMenuItems__Lorg_eclipse_swt_widgets_Menu_2ZZ(dropDownMenu, subMenuButton.getSelection__(), subSubMenuButton.getSelection__());
      }
    }
    if (popUpButton.getSelection__()) {
      var popUpMenu: Menu = new Menu(new Arguments(org.eclipse.swt.widgets.Menu.Menu__Lorg_eclipse_swt_widgets_Decorations_2I, [shell_1, 8 | radioBehavior]));
      shell_1.setMenu__Lorg_eclipse_swt_widgets_Menu_2(popUpMenu);
      this.hookListeners__Lorg_eclipse_swt_widgets_Widget_2(popUpMenu);
      this.createMenuItems__Lorg_eclipse_swt_widgets_Menu_2ZZ(popUpMenu, subMenuButton.getSelection__(), subSubMenuButton.getSelection__());
    }
    shell_1.setSize__II(300, 100);
    shell_1.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Title") + shellCount);
    shell_1.addPaintListener__Lorg_eclipse_swt_events_PaintListener_2(new org.eclipse.swt.examples.controlexample.MenuTab$1(this));
    shell_1.open__();
    shellCount++;
    return;
  }
  public override function createControlGroup__(): void {
    controlGroup = new Group(tabFolderPage, 0);
    controlGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__IZ, [2, true])));
    controlGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [256 | 16])));
    controlGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Parameters"));
    styleGroup = new Group(controlGroup, 0);
    styleGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    styleGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [256 | 16])));
    styleGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Menu_Styles"));
    menuItemStyleGroup = new Group(controlGroup, 0);
    menuItemStyleGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    menuItemStyleGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [256 | 16])));
    menuItemStyleGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("MenuItem_Styles"));
    otherGroup = new Group(controlGroup, 0);
    otherGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    otherGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [256 | 16])));
    otherGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Other"));
    return;
  }
  public override function createControlWidgets__(): void {
    barButton = new Button(styleGroup, 32);
    barButton.setText__Ljava_lang_String_2("SWT.BAR");
    dropDownButton = new Button(styleGroup, 32);
    dropDownButton.setText__Ljava_lang_String_2("SWT.DROP_DOWN");
    popUpButton = new Button(styleGroup, 32);
    popUpButton.setText__Ljava_lang_String_2("SWT.POP_UP");
    noRadioGroupButton = new Button(styleGroup, 32);
    noRadioGroupButton.setText__Ljava_lang_String_2("SWT.NO_RADIO_GROUP");
    leftToRightButton = new Button(styleGroup, 16);
    leftToRightButton.setText__Ljava_lang_String_2("SWT.LEFT_TO_RIGHT");
    leftToRightButton.setSelection__Z(true);
    rightToLeftButton = new Button(styleGroup, 16);
    rightToLeftButton.setText__Ljava_lang_String_2("SWT.RIGHT_TO_LEFT");
    cascadeButton = new Button(menuItemStyleGroup, 32);
    cascadeButton.setText__Ljava_lang_String_2("SWT.CASCADE");
    checkButton = new Button(menuItemStyleGroup, 32);
    checkButton.setText__Ljava_lang_String_2("SWT.CHECK");
    pushButton = new Button(menuItemStyleGroup, 32);
    pushButton.setText__Ljava_lang_String_2("SWT.PUSH");
    radioButton = new Button(menuItemStyleGroup, 32);
    radioButton.setText__Ljava_lang_String_2("SWT.RADIO");
    separatorButton = new Button(menuItemStyleGroup, 32);
    separatorButton.setText__Ljava_lang_String_2("SWT.SEPARATOR");
    imagesButton = new Button(otherGroup, 32);
    imagesButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Images"));
    acceleratorsButton = new Button(otherGroup, 32);
    acceleratorsButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Accelerators"));
    mnemonicsButton = new Button(otherGroup, 32);
    mnemonicsButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Mnemonics"));
    subMenuButton = new Button(otherGroup, 32);
    subMenuButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("SubMenu"));
    subSubMenuButton = new Button(otherGroup, 32);
    subSubMenuButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("SubSubMenu"));
    new Label(controlGroup, 0);
    createButton = new Button(controlGroup, 0);
    createButton.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [128])));
    createButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Create_Shell"));
    closeAllButton = new Button(controlGroup, 0);
    closeAllButton.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [32])));
    closeAllButton.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Close_All_Shells"));
    createButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.MenuTab$2(this));
    closeAllButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.MenuTab$3(this));
    subMenuButton.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.MenuTab$4(this));
    barButton.setSelection__Z(true);
    dropDownButton.setSelection__Z(true);
    popUpButton.setSelection__Z(true);
    cascadeButton.setSelection__Z(true);
    checkButton.setSelection__Z(true);
    pushButton.setSelection__Z(true);
    radioButton.setSelection__Z(true);
    separatorButton.setSelection__Z(true);
    subSubMenuButton.setEnabled__Z(subMenuButton.getSelection__());
    return;
  }
  public function createMenuItems__Lorg_eclipse_swt_widgets_Menu_2ZZ(menu: Menu, createSubMenu: Boolean, createSubSubMenu: Boolean): void {
    var item: MenuItem;
    if (pushButton.getSelection__()) {
      item = new MenuItem(new Arguments(org.eclipse.swt.widgets.MenuItem.MenuItem__Lorg_eclipse_swt_widgets_Menu_2I, [menu, 8]));
      item.setText__Ljava_lang_String_2(this.getMenuItemText__Ljava_lang_String_2("Push"));
      if (acceleratorsButton.getSelection__())
        item.setAccelerator__I(SWT.MOD1 + SWT.MOD2 + 80);
      if (imagesButton.getSelection__())
        item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[0]);
      this.hookListeners__Lorg_eclipse_swt_widgets_Widget_2(item);
    }
    if (separatorButton.getSelection__()) {
      new MenuItem(new Arguments(org.eclipse.swt.widgets.MenuItem.MenuItem__Lorg_eclipse_swt_widgets_Menu_2I, [menu, 2]));
    }
    if (checkButton.getSelection__()) {
      item = new MenuItem(new Arguments(org.eclipse.swt.widgets.MenuItem.MenuItem__Lorg_eclipse_swt_widgets_Menu_2I, [menu, 32]));
      item.setText__Ljava_lang_String_2(this.getMenuItemText__Ljava_lang_String_2("Check"));
      if (acceleratorsButton.getSelection__())
        item.setAccelerator__I(SWT.MOD1 + SWT.MOD2 + 67);
      if (imagesButton.getSelection__())
        item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[1]);
      this.hookListeners__Lorg_eclipse_swt_widgets_Widget_2(item);
    }
    if (radioButton.getSelection__()) {
      item = new MenuItem(new Arguments(org.eclipse.swt.widgets.MenuItem.MenuItem__Lorg_eclipse_swt_widgets_Menu_2I, [menu, 16]));
      item.setText__Ljava_lang_String_2(this.getMenuItemText__Ljava_lang_String_2("1Radio"));
      if (acceleratorsButton.getSelection__())
        item.setAccelerator__I(SWT.MOD1 + SWT.MOD2 + 49);
      if (imagesButton.getSelection__())
        item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[2]);
      item.setSelection__Z(true);
      this.hookListeners__Lorg_eclipse_swt_widgets_Widget_2(item);
      item = new MenuItem(new Arguments(org.eclipse.swt.widgets.MenuItem.MenuItem__Lorg_eclipse_swt_widgets_Menu_2I, [menu, 16]));
      item.setText__Ljava_lang_String_2(this.getMenuItemText__Ljava_lang_String_2("2Radio"));
      if (acceleratorsButton.getSelection__())
        item.setAccelerator__I(SWT.MOD1 + SWT.MOD2 + 50);
      if (imagesButton.getSelection__())
        item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[2]);
      this.hookListeners__Lorg_eclipse_swt_widgets_Widget_2(item);
    }
    if (createSubMenu && cascadeButton.getSelection__()) {
      item = new MenuItem(new Arguments(org.eclipse.swt.widgets.MenuItem.MenuItem__Lorg_eclipse_swt_widgets_Menu_2I, [menu, 64]));
      item.setText__Ljava_lang_String_2(this.getMenuItemText__Ljava_lang_String_2("Cascade"));
      if (imagesButton.getSelection__())
        item.setImage__Lorg_eclipse_swt_graphics_Image_2(instance.images[1]);
      this.hookListeners__Lorg_eclipse_swt_widgets_Widget_2(item);
      var subMenu: Menu = new Menu(new Arguments(org.eclipse.swt.widgets.Menu.Menu__Lorg_eclipse_swt_widgets_Decorations_2I, [menu.getShell__(), 4]));
      item.setMenu__Lorg_eclipse_swt_widgets_Menu_2(subMenu);
      this.hookListeners__Lorg_eclipse_swt_widgets_Widget_2(subMenu);
      this.createMenuItems__Lorg_eclipse_swt_widgets_Menu_2ZZ(subMenu, createSubSubMenu, false);
    }
    return;
  }
  public function getMenuItemText__Ljava_lang_String_2(item: String): String {
    var cascade: Boolean = Object(item).equals__Ljava_lang_Object_2("Cascade");
    var mnemonic: Boolean = mnemonicsButton.getSelection__();
    var accelerator: Boolean = acceleratorsButton.getSelection__();
    var acceleratorKey: uint = Object(item).charAt__I(0);
    if (mnemonic && accelerator && !cascade) {
      return ControlExample.getResourceString__Ljava_lang_String_2(item + "WithMnemonic") + "\tCtrl+Shift+" + String.fromCharCode(acceleratorKey);
    }
    if (accelerator && !cascade) {
      return ControlExample.getResourceString__Ljava_lang_String_2(item) + "\tCtrl+Shift+" + String.fromCharCode(acceleratorKey);
    }
    if (mnemonic) {
      return ControlExample.getResourceString__Ljava_lang_String_2(item + "WithMnemonic");
    }
    return ControlExample.getResourceString__Ljava_lang_String_2(item);
  }
  public override function getTabText__(): String {
    return "Menu";
  }
}
}
