package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Widget;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ProgressBarTab extends RangeTab {
  internal var progressBar1: ProgressBar;
  internal var progressBarGroup: Group;
  internal var smoothButton: Button;
  internal var indeterminateButton: Button;
  function ProgressBarTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    progressBarGroup = new Group(exampleGroup, 0);
    progressBarGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    progressBarGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    progressBarGroup.setText__Ljava_lang_String_2("ProgressBar");
    return;
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (horizontalButton.getSelection__())
      style |= 256;
    if (verticalButton.getSelection__())
      style |= 512;
    if (smoothButton.getSelection__())
      style |= 65536;
    if (borderButton.getSelection__())
      style |= 2048;
    if (indeterminateButton.getSelection__())
      style |= 2;
    progressBar1 = new ProgressBar(progressBarGroup, style);
    return;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    smoothButton = new Button(styleGroup, 32);
    smoothButton.setText__Ljava_lang_String_2("SWT.SMOOTH");
    indeterminateButton = new Button(styleGroup, 32);
    indeterminateButton.setText__Ljava_lang_String_2("SWT.INDETERMINATE");
    return;
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(progressBar1);
  }
  public override function getMethodNames__(): JavaArray {
    return new JavaArray("[Ljava/lang/String;").values("Selection", "State", "ToolTipText");
  }
  public override function getShortTabText__(): String {
    return "PB";
  }
  public override function getTabText__(): String {
    return "ProgressBar";
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    if (indeterminateButton.getSelection__()) {
      selectionSpinner.setEnabled__Z(false);
      minimumSpinner.setEnabled__Z(false);
      maximumSpinner.setEnabled__Z(false);
    } else {
      selectionSpinner.setEnabled__Z(true);
      minimumSpinner.setEnabled__Z(true);
      maximumSpinner.setEnabled__Z(true);
    }
    smoothButton.setSelection__Z((progressBar1.getStyle__() & 65536) != 0);
    indeterminateButton.setSelection__Z((progressBar1.getStyle__() & 2) != 0);
    return;
  }
  public override function getDefaultMaximum__(): int {
    return progressBar1.getMaximum__();
  }
  public override function getDefaultMinimum__(): int {
    return progressBar1.getMinimum__();
  }
  public override function getDefaultSelection__(): int {
    return progressBar1.getSelection__();
  }
  public override function setWidgetMaximum__(): void {
    progressBar1.setMaximum__I(maximumSpinner.getSelection__());
    this.updateSpinners__();
  }
  public override function setWidgetMinimum__(): void {
    progressBar1.setMinimum__I(minimumSpinner.getSelection__());
    this.updateSpinners__();
  }
  public override function setWidgetSelection__(): void {
    progressBar1.setSelection__I(selectionSpinner.getSelection__());
    this.updateSpinners__();
  }
  public function updateSpinners__(): void {
    minimumSpinner.setSelection__I(progressBar1.getMinimum__());
    selectionSpinner.setSelection__I(progressBar1.getSelection__());
    maximumSpinner.setSelection__I(progressBar1.getMaximum__());
  }
}
}
