package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class RangeTab extends Tab {
  internal var horizontalButton: Button;
  internal var verticalButton: Button;
  internal var orientationButtons: Boolean = true;
  internal var minimumSpinner: Spinner;
  internal var selectionSpinner: Spinner;
  internal var maximumSpinner: Spinner;
  function RangeTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createControlWidgets__(): void {
    this.createMinimumGroup__();
    this.createMaximumGroup__();
    this.createSelectionGroup__();
    return;
  }
  public function createMaximumGroup__(): void {
    var maximumGroup: Group = new Group(controlGroup, 0);
    maximumGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    maximumGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Maximum"));
    maximumGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [768])));
    maximumSpinner = new Spinner(maximumGroup, 2048);
    maximumSpinner.setMaximum__I(100000);
    maximumSpinner.setSelection__I(this.getDefaultMaximum__());
    maximumSpinner.setPageIncrement__I(100);
    maximumSpinner.setIncrement__I(1);
    maximumSpinner.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 16777216, true, false])));
    maximumSpinner.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.RangeTab$1(this));
    return;
  }
  public function createMinimumGroup__(): void {
    var minimumGroup: Group = new Group(controlGroup, 0);
    minimumGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    minimumGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Minimum"));
    minimumGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__I, [768])));
    minimumSpinner = new Spinner(minimumGroup, 2048);
    minimumSpinner.setMaximum__I(100000);
    minimumSpinner.setSelection__I(this.getDefaultMinimum__());
    minimumSpinner.setPageIncrement__I(100);
    minimumSpinner.setIncrement__I(1);
    minimumSpinner.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 16777216, true, false])));
    minimumSpinner.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.RangeTab$2(this));
    return;
  }
  public function createSelectionGroup__(): void {
    var selectionGroup: Group = new Group(controlGroup, 0);
    selectionGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    var gridData: GridData = new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 1, false, false]));
    selectionGroup.setLayoutData__Ljava_lang_Object_2(gridData);
    selectionGroup.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Selection"));
    selectionSpinner = new Spinner(selectionGroup, 2048);
    selectionSpinner.setMaximum__I(100000);
    selectionSpinner.setSelection__I(this.getDefaultSelection__());
    selectionSpinner.setPageIncrement__I(100);
    selectionSpinner.setIncrement__I(1);
    selectionSpinner.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 16777216, true, false])));
    selectionSpinner.addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.swt.examples.controlexample.RangeTab$3(this));
    return;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    if (orientationButtons) {
      horizontalButton = new Button(styleGroup, 16);
      horizontalButton.setText__Ljava_lang_String_2("SWT.HORIZONTAL");
      verticalButton = new Button(styleGroup, 16);
      verticalButton.setText__Ljava_lang_String_2("SWT.VERTICAL");
    }
    borderButton = new Button(styleGroup, 32);
    borderButton.setText__Ljava_lang_String_2("SWT.BORDER");
    return;
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    if (!instance.startup) {
      this.setWidgetMinimum__();
      this.setWidgetMaximum__();
      this.setWidgetSelection__();
    }
    var widgets: JavaArray = this.getExampleWidgets__();
    if (widgets.length != 0) {
      if (orientationButtons) {
        horizontalButton.setSelection__Z((widgets[0].getStyle__() & 256) != 0);
        verticalButton.setSelection__Z((widgets[0].getStyle__() & 512) != 0);
      }
      borderButton.setSelection__Z((widgets[0].getStyle__() & 2048) != 0);
    }
    return;
  }
  public function getDefaultMaximum__(): int { // abstract
    return 0;
  }
  public function getDefaultMinimum__(): int { // abstract
    return 0;
  }
  public function getDefaultSelection__(): int { // abstract
    return 0;
  }
  public function setWidgetMaximum__(): void { } // abstract
  public function setWidgetMinimum__(): void { } // abstract
  public function setWidgetSelection__(): void { } // abstract
}
}
