package org.eclipse.swt.examples.controlexample {
import org.eclipse.swt.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Widget;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class SashFormTab extends Tab {
  internal var sashFormGroup: Group;
  internal var form: SashForm;
  internal var list1: List;
  internal var list2: List;
  internal var text: Text;
  internal var horizontalButton: Button;
  internal var verticalButton: Button;
  internal var smoothButton: Button;
  public static var ListData0: JavaArray = new JavaArray("[Ljava/lang/String;").values(ControlExample.getResourceString__Ljava_lang_String_2("ListData0_0"), ControlExample.getResourceString__Ljava_lang_String_2("ListData0_1"), ControlExample.getResourceString__Ljava_lang_String_2("ListData0_2"), ControlExample.getResourceString__Ljava_lang_String_2("ListData0_3"), ControlExample.getResourceString__Ljava_lang_String_2("ListData0_4"), ControlExample.getResourceString__Ljava_lang_String_2("ListData0_5"), ControlExample.getResourceString__Ljava_lang_String_2("ListData0_6"), ControlExample.getResourceString__Ljava_lang_String_2("ListData0_7"));
  public static var ListData1: JavaArray = new JavaArray("[Ljava/lang/String;").values(ControlExample.getResourceString__Ljava_lang_String_2("ListData1_0"), ControlExample.getResourceString__Ljava_lang_String_2("ListData1_1"), ControlExample.getResourceString__Ljava_lang_String_2("ListData1_2"), ControlExample.getResourceString__Ljava_lang_String_2("ListData1_3"), ControlExample.getResourceString__Ljava_lang_String_2("ListData1_4"), ControlExample.getResourceString__Ljava_lang_String_2("ListData1_5"), ControlExample.getResourceString__Ljava_lang_String_2("ListData1_6"), ControlExample.getResourceString__Ljava_lang_String_2("ListData1_7"));
  function SashFormTab(instance: ControlExample) {
    super(instance);
    return;
  }
  public override function createExampleGroup__(): void {
    super.createExampleGroup__();
    sashFormGroup = new Group(exampleGroup, 0);
    sashFormGroup.setLayout__Lorg_eclipse_swt_widgets_Layout_2(new GridLayout(new Arguments(org.eclipse.swt.layout.GridLayout.GridLayout__, [])));
    sashFormGroup.setLayoutData__Ljava_lang_Object_2(new GridData(new Arguments(org.eclipse.swt.layout.GridData.GridData__IIZZ, [4, 4, true, true])));
    sashFormGroup.setText__Ljava_lang_String_2("SashForm");
    return;
  }
  public override function createExampleWidgets__(): void {
    var style: int = this.getDefaultStyle__();
    if (horizontalButton.getSelection__())
      style |= 256;
    if (verticalButton.getSelection__())
      style |= 512;
    if (smoothButton.getSelection__())
      style |= 65536;
    form = new SashForm(sashFormGroup, style);
    list1 = new List(form, 512 | 256 | 2048);
    list1.setItems___3Ljava_lang_String_2(ListData0);
    list2 = new List(form, 512 | 256 | 2048);
    list2.setItems___3Ljava_lang_String_2(ListData1);
    text = new Text(form, 2 | 2048);
    text.setText__Ljava_lang_String_2(ControlExample.getResourceString__Ljava_lang_String_2("Multi_line"));
    form.setWeights___3I(new JavaArray("[I").values(1, 1, 1));
    return;
  }
  public override function createStyleGroup__(): void {
    super.createStyleGroup__();
    horizontalButton = new Button(styleGroup, 16);
    horizontalButton.setText__Ljava_lang_String_2("SWT.HORIZONTAL");
    horizontalButton.setSelection__Z(true);
    verticalButton = new Button(styleGroup, 16);
    verticalButton.setText__Ljava_lang_String_2("SWT.VERTICAL");
    verticalButton.setSelection__Z(false);
    smoothButton = new Button(styleGroup, 32);
    smoothButton.setText__Ljava_lang_String_2("SWT.SMOOTH");
    smoothButton.setSelection__Z(false);
    return;
  }
  public override function getExampleWidgets__(): JavaArray {
    return new JavaArray("[Lorg/eclipse/swt/widgets/Widget;").values(form);
  }
  public override function getTabText__(): String {
    return "SashForm";
  }
  public override function setExampleWidgetState__(): void {
    super.setExampleWidgetState__();
    horizontalButton.setSelection__Z((form.getStyle__() & 256) != 0);
    verticalButton.setSelection__Z((form.getStyle__() & 512) != 0);
    smoothButton.setSelection__Z((form.getStyle__() & 65536) != 0);
  }
}
}
